/*
 * CreateConstraintsDiagnosticStokes.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsDiagnosticStokes(DataSet** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){

	int i;
	DataSet* constraints = NULL;
	Spc*    spc  = NULL;
	int count=0;

	/*Create constraints: */
	constraints = new DataSet(ConstraintsEnum);

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if (!iomodel->isstokes)goto cleanup_and_return;

	/*Fetch data: */
	IoModelFetchData(&iomodel->gridonstokes,NULL,NULL,iomodel_handle,"gridonstokes");

	count=1; //matlab indexing
	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i]==1)){

			if ((int)!iomodel->gridonstokes[i]){

				/*This grid will see its vx,vy and vz dofs spc'd to pattyn velocities: */
				constraints->AddObject(new Spc(count,i+1,1,0));
				count++;

				constraints->AddObject(new Spc(count,i+1,2,0));
				count++;

				constraints->AddObject(new Spc(count,i+1,3,0));
				count++;
			}
		} //if((my_vertices[i]==1))
	}

	/*Free data: */
	xfree((void**)&iomodel->gridonstokes);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	constraints->Presort();

	cleanup_and_return:

	/*Assign output pointer: */
	*pconstraints=constraints;
}	
