/*!\file: CreateParametersBalancedvelocities.cpp
 * \brief driver for creating parameters dataset, for prognostic analysis.
 */ 

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../ModelProcessorx.h"

void CreateParametersBalancedvelocities(DataSet** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	Param*   param = NULL;
	DataSet* parameters=NULL;
	int      count;
	int      i;
	double* u_g=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	count=parameters->Size();

	/*Get vx and vy: */
	IoModelFetchData(&iomodel->vx,NULL,NULL,iomodel_handle,"vx");
	IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,"vy");
	IoModelFetchData(&iomodel->vz,NULL,NULL,iomodel_handle,"vz");

	u_g=(double*)xcalloc(iomodel->numberofvertices*3,sizeof(double));

	if(iomodel->vx) for(i=0;i<iomodel->numberofvertices;i++)u_g[3*i+0]=iomodel->vx[i]/iomodel->yts;
	if(iomodel->vy) for(i=0;i<iomodel->numberofvertices;i++)u_g[3*i+1]=iomodel->vy[i]/iomodel->yts;
	if(iomodel->vz) for(i=0;i<iomodel->numberofvertices;i++)u_g[3*i+2]=iomodel->vz[i]/iomodel->yts;

	count++;
	param= new Param(count,"u_g",DOUBLEVEC);
	param->SetDoubleVec(u_g,3*iomodel->numberofvertices,3);
	parameters->AddObject(param);

	xfree((void**)&iomodel->vx);
	xfree((void**)&iomodel->vy);
	xfree((void**)&iomodel->vz);
	xfree((void**)&u_g);

	/*Get thickness: */
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	
	count++;
	param= new Param(count,"h_g",DOUBLEVEC);
	if(iomodel->thickness) param->SetDoubleVec(iomodel->thickness,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->thickness,0,0);
	parameters->AddObject(param);

	/*Free thickness: */
	xfree((void**)&iomodel->thickness);

	/*Get melting: */
	IoModelFetchData(&iomodel->melting,NULL,NULL,iomodel_handle,"melting");
	if(iomodel->melting) for(i=0;i<iomodel->numberofvertices;i++)iomodel->melting[i]=iomodel->melting[i]/iomodel->yts;
	
	count++;
	param= new Param(count,"m_g",DOUBLEVEC);
	if(iomodel->melting) param->SetDoubleVec(iomodel->melting,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->melting,0,1);
	parameters->AddObject(param);

	/*Free melting: */
	xfree((void**)&iomodel->melting);

	/*Get accumulation: */
	IoModelFetchData(&iomodel->accumulation,NULL,NULL,iomodel_handle,"accumulation");
	if(iomodel->accumulation) for(i=0;i<iomodel->numberofvertices;i++)iomodel->accumulation[i]=iomodel->accumulation[i]/iomodel->yts;
	
	count++;
	param= new Param(count,"a_g",DOUBLEVEC);
	if(iomodel->accumulation) param->SetDoubleVec(iomodel->accumulation,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->accumulation,0,0);
	parameters->AddObject(param);

	/*Free accumulation: */
	xfree((void**)&iomodel->accumulation);


	/*Assign output pointer: */
	*pparameters=parameters;
}
