/*
 * CreateConstraintsThermal.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsThermal(DataSet** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){

	int i;
	int count=0;
	
	DataSet* constraints = NULL;
	Spc*    spc  = NULL;

	/*Create constraints: */
	constraints = new DataSet(ConstraintsEnum);

	/*return if 2d mesh*/
	if (strcmp(iomodel->meshtype,"2d")==0)goto cleanup_and_return;

	/*Fetch data: */
	IoModelFetchData(&iomodel->spctemperature,NULL,NULL,iomodel_handle,"spctemperature");

	count=1;

	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i]==1)){

			if ((int)iomodel->spctemperature[2*i]){

				constraints->AddObject(new Spc(count,i+1,1,iomodel->spctemperature[2*i+1]));
				count++;

			}

		} //if((my_grids[i]==1))
	}

	/*Free data: */
	xfree((void**)&iomodel->spctemperature);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	constraints->Presort();

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
