/*!\file: CreateParametersPrognostic.cpp
 * \brief driver for creating parameters dataset, for prognostic analysis.
 */ 


#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../ModelProcessorx.h"

void CreateParametersPrognostic2(DataSet** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	Param*   param = NULL;
	DataSet* parameters=NULL;
	int      count;
	int      i;
	int      dim;
	double*  vx_g=NULL;
	double*  vy_g=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	count=parameters->Size();

	/*Get vx and vy: */
	IoModelFetchData(&iomodel->vx,NULL,NULL,iomodel_handle,"vx");
	IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,"vy");

	vx_g=(double*)xcalloc(iomodel->numberofvertices,sizeof(double));
	vy_g=(double*)xcalloc(iomodel->numberofvertices,sizeof(double));

	if(iomodel->vx) for(i=0;i<iomodel->numberofvertices;i++)vx_g[i]=iomodel->vx[i]/iomodel->yts;
	if(iomodel->vy) for(i=0;i<iomodel->numberofvertices;i++)vy_g[i]=iomodel->vy[i]/iomodel->yts;

	count++;
	param= new Param(count,"vx_g",DOUBLEVEC);
	param->SetDoubleVec(vx_g,iomodel->numberofvertices,1);
	parameters->AddObject(param);
	count++;
	param= new Param(count,"vy_g",DOUBLEVEC);
	param->SetDoubleVec(vy_g,iomodel->numberofvertices,1);
	parameters->AddObject(param);

	xfree((void**)&iomodel->vx);
	xfree((void**)&iomodel->vy);
	xfree((void**)&vx_g);
	xfree((void**)&vy_g);

	/*Get thickness: */
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	
	count++;
	param= new Param(count,"h_g",DOUBLEVEC);
	if(iomodel->thickness) param->SetDoubleVec(iomodel->thickness,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->thickness,0,0);
	parameters->AddObject(param);

	/*Free thickness: */
	xfree((void**)&iomodel->thickness);

	/*Get surface: */
	IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
	
	count++;
	param= new Param(count,"s_g",DOUBLEVEC);
	if(iomodel->surface) param->SetDoubleVec(iomodel->surface,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->surface,0,0);
	parameters->AddObject(param);

	/*Free surface: */
	xfree((void**)&iomodel->surface);

	/*Get bed: */
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	
	count++;
	param= new Param(count,"b_g",DOUBLEVEC);
	if(iomodel->bed) param->SetDoubleVec(iomodel->bed,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->bed,0,0);
	parameters->AddObject(param);

	/*Free bed: */
	xfree((void**)&iomodel->bed);

	/*Get melting: */
	IoModelFetchData(&iomodel->melting,NULL,NULL,iomodel_handle,"melting");
	if(iomodel->melting) for(i=0;i<iomodel->numberofvertices;i++)iomodel->melting[i]=iomodel->melting[i]/iomodel->yts;
	
	count++;
	param= new Param(count,"m_g",DOUBLEVEC);
	if(iomodel->melting) param->SetDoubleVec(iomodel->melting,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->melting,0,1);
	parameters->AddObject(param);

	/*Free melting: */
	xfree((void**)&iomodel->melting);

	/*Get accumulation: */
	IoModelFetchData(&iomodel->accumulation,NULL,NULL,iomodel_handle,"accumulation");
	if(iomodel->accumulation) for(i=0;i<iomodel->numberofvertices;i++)iomodel->accumulation[i]=iomodel->accumulation[i]/iomodel->yts;
	
	count++;
	param= new Param(count,"a_g",DOUBLEVEC);
	if(iomodel->accumulation) param->SetDoubleVec(iomodel->accumulation,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->accumulation,0,0);
	parameters->AddObject(param);

	/*Free accumulation: */
	xfree((void**)&iomodel->accumulation);

	/*Assign output pointer: */
	*pparameters=parameters;
}
