/*!\file: CreateParametersPrognostic.cpp
 * \brief driver for creating parameters dataset, for prognostic analysis.
 */ 


#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../ModelProcessorx.h"

void CreateParametersPrognostic(DataSet** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	Param*   param = NULL;
	DataSet* parameters=NULL;
	int      count;
	int      i;
	int      dim;
	double* u_g=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	count=parameters->Size();

	/*Get vx and vy: */
	IoModelFetchData(&iomodel->vx,NULL,NULL,iomodel_handle,"vx");
	IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,"vy");
	IoModelFetchData(&iomodel->vz,NULL,NULL,iomodel_handle,"vz");

	u_g=(double*)xcalloc(iomodel->numberofvertices*3,sizeof(double));

	if(iomodel->vx) for(i=0;i<iomodel->numberofvertices;i++)u_g[3*i+0]=iomodel->vx[i]/iomodel->yts;
	if(iomodel->vy) for(i=0;i<iomodel->numberofvertices;i++)u_g[3*i+1]=iomodel->vy[i]/iomodel->yts;
	if(iomodel->vz) for(i=0;i<iomodel->numberofvertices;i++)u_g[3*i+2]=iomodel->vz[i]/iomodel->yts;

	count++;
	param= new Param(count,"u_g",DOUBLEVEC);
	param->SetDoubleVec(u_g,3*iomodel->numberofvertices,3);
	parameters->AddObject(param);


	xfree((void**)&iomodel->vx);
	xfree((void**)&iomodel->vy);
	xfree((void**)&iomodel->vz);
	xfree((void**)&u_g);

	/*Get pressure if 3d iomodel: */
	parameters->FindParam(&dim,"dim");
	if (dim==3){ 
		IoModelFetchData(&iomodel->pressure,NULL,NULL,iomodel_handle,"pressure");
		
		count++;
		param= new Param(count,"p_g",DOUBLEVEC);
		if(iomodel->pressure) param->SetDoubleVec(iomodel->pressure,iomodel->numberofvertices,1);
		else param->SetDoubleVec(iomodel->pressure,0,0);
		parameters->AddObject(param);

		/*Free pressure: */
		xfree((void**)&iomodel->pressure);
	}

	/*Get temperature if 3d iomodel: */
	parameters->FindParam(&dim,"dim");
	if (dim==3){ 
		IoModelFetchData(&iomodel->temperature,NULL,NULL,iomodel_handle,"temperature");
		
		count++;
		param= new Param(count,"t_g",DOUBLEVEC);
		if(iomodel->temperature) param->SetDoubleVec(iomodel->temperature,iomodel->numberofvertices,1);
		else param->SetDoubleVec(iomodel->temperature,0,0);
		parameters->AddObject(param);

		/*Free temperature: */
		xfree((void**)&iomodel->temperature);
	}

	/*Get thickness: */
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	
	count++;
	param= new Param(count,"h_g",DOUBLEVEC);
	if(iomodel->thickness) param->SetDoubleVec(iomodel->thickness,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->thickness,0,0);
	parameters->AddObject(param);

	/*Free thickness: */
	xfree((void**)&iomodel->thickness);

	/*Get surface: */
	IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
	
	count++;
	param= new Param(count,"s_g",DOUBLEVEC);
	if(iomodel->surface) param->SetDoubleVec(iomodel->surface,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->surface,0,0);
	parameters->AddObject(param);

	/*Free surface: */
	xfree((void**)&iomodel->surface);

	/*Get bed: */
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	
	count++;
	param= new Param(count,"b_g",DOUBLEVEC);
	if(iomodel->bed) param->SetDoubleVec(iomodel->bed,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->bed,0,0);
	parameters->AddObject(param);

	/*Free bed: */
	xfree((void**)&iomodel->bed);

	/*Get melting: */
	IoModelFetchData(&iomodel->melting,NULL,NULL,iomodel_handle,"melting");
	if(iomodel->melting) for(i=0;i<iomodel->numberofvertices;i++)iomodel->melting[i]=iomodel->melting[i]/iomodel->yts;
	
	count++;
	param= new Param(count,"m_g",DOUBLEVEC);
	if(iomodel->melting) param->SetDoubleVec(iomodel->melting,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->melting,0,1);
	parameters->AddObject(param);

	/*Free melting: */
	xfree((void**)&iomodel->melting);

	/*Get accumulation: */
	IoModelFetchData(&iomodel->accumulation,NULL,NULL,iomodel_handle,"accumulation");
	if(iomodel->accumulation) for(i=0;i<iomodel->numberofvertices;i++)iomodel->accumulation[i]=iomodel->accumulation[i]/iomodel->yts;
	
	count++;
	param= new Param(count,"a_g",DOUBLEVEC);
	if(iomodel->accumulation) param->SetDoubleVec(iomodel->accumulation,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->accumulation,0,0);
	parameters->AddObject(param);

	/*Free accumulation: */
	xfree((void**)&iomodel->accumulation);

	/*Assign output pointer: */
	*pparameters=parameters;
}
