/*!\file: CreateParametersMelting.cpp
 * \brief driver for creating parameters dataset, for diagnostic horiz analysis.
 */ 

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../ModelProcessorx.h"

void CreateParametersMelting(DataSet** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	Param*   param = NULL;
	DataSet* parameters=NULL;
	int      count;
	int i;

	/*recover parameters : */
	parameters=*pparameters;

	/*if 2d: return*/
	if (strcmp(iomodel->meshtype,"2d")==0)goto cleanup_and_return;

	count=parameters->Size();

	/* get initial melting if transient*/
	if(iomodel->dt){

		/*Get melting: */
		IoModelFetchData(&iomodel->melting,NULL,NULL,iomodel_handle,"melting");
		if(iomodel->melting) {
			for(i=0;i<iomodel->numberofvertices;i++)iomodel->melting[i]=iomodel->melting[i]/iomodel->yts;   //m/s instead of m/yr
		}
		else{
			for(i=0;i<iomodel->numberofvertices;i++)iomodel->melting[i]=0;
		}

		count++;
		param= new Param(count,"m_g",DOUBLEVEC);
		if(iomodel->melting) param->SetDoubleVec(iomodel->melting,iomodel->numberofvertices);
		else param->SetDoubleVec(iomodel->melting,0);
		parameters->AddObject(param);

		/*Free melting: */
		xfree((void**)&iomodel->melting);
	}

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pparameters=parameters;
}
