/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

enum definitions{

	/*Datasets {{{1*/
	DatasetsEnum,
	ElementsEnum,
	NodesEnum,
	ConstraintsEnum,
	LoadsEnum,
	MaterialsEnum,
	ParametersEnum,
	ResultsEnum,
	VerticesEnum,
	/*}}}*/
	/*Analysis types {{{1 */
	AnalysisEnum,
	//diagnostic
	DiagnosticAnalysisEnum,
	HorizAnalysisEnum,
	StokesAnalysisEnum,
	HutterAnalysisEnum,
	VertAnalysisEnum,
	//control
	ControlAnalysisEnum,
	AdjointAnalysisEnum,
	InverseAnalysisEnum,
	GradientAnalysisEnum,
	//thermal
	ThermalAnalysisEnum,
	//transient
	TransientAnalysisEnum,
	SteadyAnalysisEnum,
	//slope
	SlopecomputeAnalysisEnum,
	SurfaceXAnalysisEnum,
	SurfaceYAnalysisEnum,
	BedXAnalysisEnum,
	BedYAnalysisEnum,
	//prognostic
	PrognosticAnalysisEnum,
	Prognostic2AnalysisEnum,
	BalancedthicknessAnalysisEnum,
	Balancedthickness2AnalysisEnum,
	BalancedvelocitiesAnalysisEnum,
	//melting
	MeltingAnalysisEnum,
	//mesh2grid
	Mesh2gridAnalysisEnum,
	//parameters
	ParametersAnalysisEnum,
	//steadystate
	SteadystateAnalysisEnum,
	//none
	NoneAnalysisEnum,
	/*}}}*/
	/*Formulations {{{1*/
	FormulationEnum,
	NoneFormulationEnum,
	HutterFormulationEnum,
	MacAyealFormulationEnum,
	PattynFormulationEnum,
	StokesFormulationEnum,
	/*}}}*/
	/*Objects {{{1*/
	ObjectEnum,
	HookEnum,
	/*Elements: */
	ElementEnum,
	TriaEnum,
	ElementPropertiesEnum,
	NodePropertiesEnum,
	PentaEnum,
	BeamEnum,
	SingEnum,
	DofIndexingEnum,
	/*Grids: */
	NodeEnum,
	VertexEnum,
	/*Loads: */
	LoadEnum,
	IcefrontEnum,
	RiftfrontEnum,
	PenpairEnum,
	PengridEnum,
	NumericalfluxEnum,
	/*Materials: */
	MaterialEnum,
	MaticeEnum,
	MatparEnum,
	NumparEnum,
	/*Inputs: */
	InputEnum,
	TriaVertexInputEnum,
	SingVertexInputEnum,
	BeamVertexInputEnum,
	PentaVertexInputEnum,
	BoolInputEnum,
	IntInputEnum,
	DoubleInputEnum,
	/*Params: */
	ParamEnum,
	/*Results: */
	ResultEnum,
	/*Rgb: */
	RgbEnum,
	/*Spc: */
	SpcEnum,
	/*DofVec: */
	DofVecEnum,
	/*}}}*/
	/*Geography {{{1*/
	GeographyEnum,
	IceSheetEnum,
	IceShelfEnum,
	/*}}}*/
	/*Fill {{{1*/
	WaterEnum,
	IceEnum,
	AirEnum,
	MelangeEnum,
	/*}}}*/
	/*Inputs {{{1*/
	VxEnum,
	VyEnum,
	VzEnum,
	VxAverageEnum,
	VyAverageEnum,
	VzAverageEnum,
	VxObsEnum,
	VyObsEnum,
	VzObsEnum,
	VxOldEnum,
	VyOldEnum,
	VzOldEnum,
	DhDtEnum,
	ThicknessEnum,
	SurfaceEnum,
	BedEnum,
	DragCoefficientEnum,
	DragPEnum,
	DragQEnum,
	DragTypeEnum,
	RheologyBEnum,
	RheologyNEnum,
	MeltingRateEnum,
	AccumulationRateEnum,
	GeothermalFluxEnum,
	ElementOnIceShelfEnum,
	ElementOnBedEnum,
	ElementOnWaterEnum,
	ElementOnSurfaceEnum,
	SurfaceAreaEnum,
	SurfaceSlopexEnum,
	SurfaceSlopeyEnum,
	BedSlopexEnum,
	BedSlopeyEnum,
	WeightsEnum,
	FitEnum,
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	CollapseEnum,
	TemperatureEnum,
	PressureEnum,
	NodeOnBedEnum,
	NodeOnSurfaceEnum,
	NodeOnIceShelfEnum,
	NodeOnIceSheetEnum,
	ResetPenaltiesEnum,
	MeltingOffsetEnum
	/*}}}*/

};

/*Functions on enums: */
int EnumIsElement(int en);
int EnumIsLoad(int en);
int EnumIsMaterial(int en);

#endif
