/*!\file Penpair.h
 * \brief: header file for penpair object */

#ifndef _PENPAIR_H_
#define _PENPAIR_H_

#include "./Load.h"
#include "./Node.h"
#include "./Element.h"

class Element;
class Penpair: public Load{

	private: 

		int		id;
		
		Hook hnodes;  //hook to 2 nodes

	public:

		Penpair();
		Penpair(int penpair_id,int* penpair_node_ids);
		Penpair(int penpair_id,Hook* penpair_hnodes);
		~Penpair();

		void  Echo();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(); 
		int   MyRank();
		void  Configure(DataSet* elements,DataSet* loads,DataSet* nodes,DataSet* vertices,DataSet* materials,Parameters* parameters);
		void  CreateKMatrix(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg, int analysis_type,int sub_analysis_type);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVector(Vec pg,double kmax,int analysis_type,int sub_analysis_type);
		Object* copy();

};

#endif  /* _PENPAIR_H_ */


