/*!\file Pengrid.h
 * \brief: header file for pengrid object */

#ifndef _PENGRID_H_
#define _PENGRID_H_

#include "./Load.h"
#include "./Node.h"
#include "./Element.h"
#include "./Matpar.h"

class Element;
class Pengrid: public Load{

	private: 

		int		id;
		
		Hook hnode;  //hook to 1 node
		Hook helement;  //hook to 1 element
		Hook hmatpar; //hook to 1 matpar

		Parameters* parameters; //pointer to solution parameters
		Inputs*  inputs;
	
		/*internals: */
		int active;
		int zigzag_counter;

	public:

		/*FUNCTION constructors, destructors {{{1*/
		Pengrid();
		Pengrid(int pengrid_id,int pengrid_node_id, int pengrid_element_id,int pengrid_matpar_id);
		Pengrid(int pengrid_id,Hook* pengrid_hnode, Hook* pengrid_helement,Hook* pengrid_hmatpar, Parameters* pengrid_parameters, Inputs* pengrid_inputs);
		Pengrid(int index, int id, IoModel* iomodel);
		~Pengrid();
		/*}}}*/
		/*FUNCTION object management {{{1*/
		void  Configure(DataSet* elementsin,DataSet* loadsin,DataSet* nodesin,DataSet* verticesin,DataSet* materialsin,Parameters* parametersin);
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   GetId(); 
		char* GetName();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		/*}}}*/
		/*FUNCTION element numerical routines {{{1*/
		void  DistributeNumDofs(int* numdofspernode,int analysis_type,int sub_analysis_type);
		void  CreateKMatrix(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg, int analysis_type,int sub_analysis_type);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVector(Vec pg,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreateKMatrixDiagnosticStokes(Mat Kgg,double kmax,int analysis_type,int sub_analysis_type);
		void  GetDofList(int* doflist,int* pnumberofdofspernode);
		void  PenaltyCreateKMatrixThermal(Mat Kgg,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreateKMatrixMelting(Mat Kgg,double kmax,int analysis_type,int sub_analysis_type);
		void  MatparConfiguration(Matpar* matpar,int matpar_offset);
		void  PenaltyCreatePVectorThermal(Vec pg, double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVectorMelting(Vec pg, double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyConstrain(int* punstable,int analysis_type,int sub_analysis_type);
		void  PenaltyConstrainThermal(int* punstable,int analysis_type,int sub_analysis_type);
		
		/*updates:*/
		void  UpdateFromDakota(void* inputs);
		void  UpdateInputs(double* solution, int analysis_type, int sub_analysis_type);
		/*}}}*/

};

#endif  /* _PENGRID_H_ */


