/*! \file CreateLoadsThermal.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../IoModel.h"

void	CreateLoadsThermal(DataSet** ploads, IoModel* iomodel,ConstDataHandle iomodel_handle){

	int i;

	DataSet*    loads    = NULL;
	Pengrid*    pengrid  = NULL;

	/*return if 2d mesh*/
	if (strcmp(iomodel->meshtype,"2d")==0)goto cleanup_and_return;

	/*Create loads: */
	loads   = new DataSet(LoadsEnum);

	//create penalties for grids: no grid can have a temperature over the melting point
	IoModelFetchData(&iomodel->spctemperature,NULL,NULL,iomodel_handle,"spctemperature");
	iomodel->CreateSingleNodeToElementConnectivity;

	for (i=0;i<iomodel->numberofvertices;i++){
	
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i]==1)){

			if (!iomodel->spctemperature[2*i]){ //No penalty applied on spc grids!

				loads->AddObject(new Pengrid(i+1,i,iomodel));
						
			}
		}
	}
	xfree((void**)&iomodel->spctemperature);
	xfree((void**)&iomodel->singlenodetoelementconnectivity);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	loads->Presort();

	cleanup_and_return:

	/*Assign output pointer: */
	*ploads=loads;

}
