/*!\file Icefront.h
 * \brief: header file for icefront object
 */

#ifndef _ICEFRONT_H_
#define _ICEFRONT_H_

class Element;
class Load;
class Matpar;
class Element;
class Node;

#include "./Load.h"
#include "./Matpar.h"
#include "./Element.h"
#include "./Node.h"
#include "../ModelProcessorx/IoModel.h"

#define MAX_ICEFRONT_GRIDS 4 //max number of grids for a certain load
#define ICEFRONTSTRING 20 //max string length

class Icefront: public Load {

	private: 
		char  type[ICEFRONTSTRING];
		int   fill;
		int	sid;
	
		/*material: */
		int     mparid; //material id
		Matpar* matpar; 
		int     matpar_offset;
	
		/*element of icefront: */
		int 	   element_type;
		int      eid;  //id of element on ice front
		Element* element;
		int      element_offset;

		/*nodes: */
		int   node_ids[MAX_ICEFRONT_GRIDS]; //node ids
		Node* nodes[MAX_ICEFRONT_GRIDS]; //node pointers
		int   node_offsets[MAX_ICEFRONT_GRIDS]; //node offsets in nodes dataset

		/*properties: */
		double		h[MAX_ICEFRONT_GRIDS]; //thickness
		double		b[MAX_ICEFRONT_GRIDS]; //bed

	public:

		/*constructors: {{{1*/
		Icefront();
		Icefront(char type[ICEFRONTSTRING],int fill,int sid, int mparid, int eid, int element_type, int node_ids[MAX_ICEFRONT_GRIDS],double h[MAX_ICEFRONT_GRIDS],double	b[MAX_ICEFRONT_GRIDS]);
		void Init(char type[ICEFRONTSTRING],int fill,int sid, int mparid, int eid, int element_type, int node_ids[MAX_ICEFRONT_GRIDS],double h[MAX_ICEFRONT_GRIDS],double	b[MAX_ICEFRONT_GRIDS]);
		Icefront(int sid, int i, IoModel* iomodel);
		~Icefront();
		/*}}}*/
		/*object management: {{{1*/
		void  Configure(void* elements,void* nodes,void* materials);
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   GetId(); 
		char* GetName();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();

		/*}}}*/
		/*numerics: {{{1*/
		void  DistributeNumDofs(int* numdofspernode,int analysis_type,int sub_analysis_type);
		void  CreateKMatrix(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  UpdateFromInputs(void* inputs);
		void  CreatePVector(Vec pg, void* inputs, int analysis_type,int sub_analysis_type);
		void  CreatePVectorDiagnosticHoriz( Vec pg, void* inputs, int analysis_type,int sub_analysis_type);
		void  CreatePVectorDiagnosticHorizSegment( Vec pg,void* inputs, int analysis_type,int sub_analysis_type);
		void  CreatePVectorDiagnosticHorizQuad( Vec pg,void* inputs, int analysis_type,int sub_analysis_type);
		void  CreatePVectorDiagnosticStokes( Vec pg,void* inputs, int analysis_type,int sub_analysis_type);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  SegmentPressureLoad(double* pe_g,double rho_water,double rho_ice,double gravity, double* thickness_list, double* bed_list, double* normal,double length);
		void  QuadPressureLoad(double* pe_g,double rho_water,double rho_ice,double gravity, double* thickness_list, double* bed_list, 
		                              double* normal1,double* normal2,double* normal3,double* normal4,double* xyz_list);
		void  QuadPressureLoadStokes(double* pe_g,double rho_water,double rho_ice,double gravity, double* thickness_list, double* bed_list, 
		                              double* normal1,double* normal2,double* normal3,double* normal4,double* xyz_list);
		void  PenaltyCreateKMatrix(Mat Kgg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVector(Vec pg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		/*}}}*/
};

#endif  /* _ICEFRONT_H_ */
