/*! \file Inputs.h 
 *  \brief: header file for inputs object
 */

#ifndef _INPUTS_H_
#define _INPUTS_H_

class Input;
#include "./DataSet.h"

class Inputs: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Inputs();
		Inputs(int enum_type);
		~Inputs();
		/*}}}*/
		/*numerics: {{{1*/
		void GetParameterValue(bool* pvalue,int enum_type);
		void GetParameterValue(int* pvalue,int enum_type);
		void GetParameterValue(double* pvalue,int enum_type);
		void GetParameterValue(double* pvalue,double* gauss,int enum_type);
		void GetParameterValue(double* pvalue,double* gauss,int enum_type,double defaultvalue);
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss,int enum_type);
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss,int enum_type,double* defaultvalues);
		int  AddInput(Input* in_input);
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss,int enum_type);
		void GetStrainRate(double* epsilon,double* xyz_list, double* gauss, int xenum, int yenum);
		void GetStrainRateStokes(double* epsilon,double* xyz_list, double* gauss, int xenum, int yenum,int yenum);
		/*}}}*/

};
#endif  /* _INPUTS_H */
