/*! \file PentaVertexInput.h 
 *  \brief: header file for triavertexinput object
 */

#include "./Input.h"

#ifndef _PENTAVERTEXINPUT_H_
#define _PENTAVERTEXINPUT_H_

class PentaVertexInput: public Input{

	private: 
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		double values[6];

	public:

		/*constructors, destructors: {{{1*/
		PentaVertexInput();
		PentaVertexInput(int enum_type,double* values);
		~PentaVertexInput();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   GetId(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();

		/*}}}*/
		/*numerics: {{{1*/
		/*}}}*/

};
#endif  /* _PENTAVERTEXINPUT_H */
