/*! \file SingVertexInput.h 
 *  \brief: header file for triavertexinput object
 */

#include "./Input.h"

#ifndef _SINGVERTEXINPUT_H_
#define _SINGVERTEXINPUT_H_

class SingVertexInput: public Input{

	private: 
		/*just hold 1 value for 1 vertex: */
		int    enum_type;
		double value;

	public:

		/*constructors, destructors: {{{1*/
		SingVertexInput();
		SingVertexInput(int enum_type,double value);
		~SingVertexInput();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   GetId(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();

		/*}}}*/
		/*numerics: {{{1*/
		/*}}}*/

};
#endif  /* _SINGVERTEXINPUT_H */
