/*!\file SingVertexInput.c
 * \brief: implementation of the SingVertexInput object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./SingVertexInput.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../DataSet/DataSet.h"
#include "../include/typedefs.h"
#include "../include/macros.h"

/*Object constructors and destructor*/
/*FUNCTION SingVertexInput::SingVertexInput(){{{1*/
SingVertexInput::SingVertexInput(){
	return;
}
/*}}}*/
/*FUNCTION SingVertexInput::SingVertexInput(double* values){{{1*/
SingVertexInput::SingVertexInput(int in_enum_type,double in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION SingVertexInput::~SingVertexInput(){{{1*/
SingVertexInput::~SingVertexInput(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION SingVertexInput::copy{{{1*/
Object* SingVertexInput::copy() {
	
	return new SingVertexInput(this->enum_type,this->value);

}
/*}}}*/
/*FUNCTION SingVertexInput::DeepEcho{{{1*/
void SingVertexInput::DeepEcho(void){

	printf("SingVertexInput:\n");
	printf("   enum: %i\n",this->enum_type);
	printf("   %g\n",this->value);
}
/*}}}*/
/*FUNCTION SingVertexInput::Demarshall{{{1*/
void  SingVertexInput::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION SingVertexInput::Echo {{{1*/
void SingVertexInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION SingVertexInput::Enum{{{1*/
int SingVertexInput::Enum(void){

	return SingVertexInputEnum;

}
/*}}}*/
/*FUNCTION SingVertexInput::EnumType{{{1*/
int SingVertexInput::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION SingVertexInput::GetId{{{1*/
int    SingVertexInput::GetId(void){ return -1; }
/*}}}*/
/*FUNCTION SingVertexInput::GetName{{{1*/
char* SingVertexInput::GetName(void){
	return "triavertexinput";
}
/*}}}*/
/*FUNCTION SingVertexInput::Marshall{{{1*/
void  SingVertexInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of SingVertexInput: */
	enum_type=SingVertexInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall SingVertexInput data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION SingVertexInput::MarshallSize{{{1*/
int   SingVertexInput::MarshallSize(){
	
	return sizeof(value)+
		sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum type
}
/*}}}*/
/*FUNCTION SingVertexInput::MyRank{{{1*/
int    SingVertexInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*Object functions*/

