/*!\file PentaVertexInput.c
 * \brief: implementation of the PentaVertexInput object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./PentaVertexInput.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../DataSet/DataSet.h"
#include "../include/typedefs.h"
#include "../include/macros.h"

/*Object constructors and destructor*/
/*FUNCTION PentaVertexInput::PentaVertexInput(){{{1*/
PentaVertexInput::PentaVertexInput(){
	return;
}
/*}}}*/
/*FUNCTION PentaVertexInput::PentaVertexInput(double* values){{{1*/
PentaVertexInput::PentaVertexInput(int in_enum_type,double* in_values){

	enum_type=in_enum_type;
	values[0]=in_values[0];
	values[1]=in_values[1];
	values[2]=in_values[2];
	values[3]=in_values[3];
	values[4]=in_values[4];
	values[5]=in_values[5];
}
/*}}}*/
/*FUNCTION PentaVertexInput::~PentaVertexInput(){{{1*/
PentaVertexInput::~PentaVertexInput(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION PentaVertexInput::copy{{{1*/
Object* PentaVertexInput::copy() {
	
	return new PentaVertexInput(this->enum_type,this->values);

}
/*}}}*/
/*FUNCTION PentaVertexInput::DeepEcho{{{1*/
void PentaVertexInput::DeepEcho(void){

	printf("PentaVertexInput:\n");
	printf("   enum: %i\n",this->enum_type);
	printf("   %g|%g|%g|%g|%g|%g\n",this->values[0],this->values[1],this->values[2],this->values[3],this->values[4],this->values[5]);
}
/*}}}*/
/*FUNCTION PentaVertexInput::Demarshall{{{1*/
void  PentaVertexInput::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&values,marshalled_dataset,sizeof(values));marshalled_dataset+=sizeof(values);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION PentaVertexInput::Echo {{{1*/
void PentaVertexInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION PentaVertexInput::Enum{{{1*/
int PentaVertexInput::Enum(void){

	return PentaVertexInputEnum;

}
/*}}}*/
/*FUNCTION PentaVertexInput::EnumType{{{1*/
int PentaVertexInput::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION PentaVertexInput::GetId{{{1*/
int    PentaVertexInput::GetId(void){ return -1; }
/*}}}*/
/*FUNCTION PentaVertexInput::GetName{{{1*/
char* PentaVertexInput::GetName(void){
	return "pentavertexinput";
}
/*}}}*/
/*FUNCTION PentaVertexInput::Marshall{{{1*/
void  PentaVertexInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of PentaVertexInput: */
	enum_type=PentaVertexInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall PentaVertexInput data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&values,sizeof(values));marshalled_dataset+=sizeof(values);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION PentaVertexInput::MarshallSize{{{1*/
int   PentaVertexInput::MarshallSize(){
	
	return sizeof(values)+
		sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum type
}
/*}}}*/
/*FUNCTION PentaVertexInput::MyRank{{{1*/
int    PentaVertexInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*Object functions*/

