
#define THISFUNCTION "Gmap"

/*  Gmap structures and prototypes  */

#ifdef MATLAB
		#include "mat.h"
		#include "mex.h"
		#include "matrix.h"

		#define printf mexPrintf
		#define fprintf(file,...) (file == stdout || file == stderr ? mexPrintf(__VA_ARGS__) : fprintf(file,__VA_ARGS__))
		#define malloc mxMalloc
		#define calloc mxCalloc
		#define realloc mxRealloc
		#define free mxFree
		#define exit(status) mexErrMsgTxt("exit=" #status)
#endif

void GmapUsage( void );


/* Input Arguments */

#define ADJMAT_IN  prhs[0]
#define VERTLB_IN  prhs[1]
#define VERTWT_IN  prhs[2]
#define EDGEWT_IN  prhs[3]
#define ARCHTYP_IN prhs[4]
#define ARCHPAR_IN prhs[5]
#define REQ_ARGS     6

/* Output Arguments */

#define RETURN_OUT plhs[0]
#define MAPTAB_OUT plhs[1]


int
gmapx (
	int                 (**pmaptabi)[2],
	int                 argcm,
	char                *argvm[],
	int                 nvi,
	int                 ne2i,
	int                 *ir,
	int                 *jc,
	int                 *vli,
	int                 *vwi,
	int                 *ewi,
	char                archtyp[],
	int                 nai,
	int                 *api);

/******************************/
/*                            */
/* This is the main function. */
/*                            */
/******************************/

void mexFunction( int nlhs,
				  mxArray *plhs[],
				  int nrhs,
				  const mxArray *prhs[] )
{
	int     argcm;
	char    **argvm=NULL;
	int     nvert =0,nedge2=0,napar =0;
	mwIndex *ir=NULL,*jc=NULL;
	int     *adjir=NULL,*adjjc=NULL;
	double  *vld=NULL,*vwd=NULL,*ewd=NULL,*apd=NULL;
	int     *vli=NULL,*vwi=NULL,*ewi=NULL,*api=NULL;
	char    *archtyp=NULL;
	int     (*maptabi)[2]=NULL;
	double* maptabd=NULL;
	int     i,j,k,ierr;

	/* Check for proper number of arguments */
   
	if      (nrhs == 0 && nlhs == 0) {
		GmapUsage();
		return;
	}
	else if (nrhs <  6 || nlhs >  2) {
		GmapUsage();
		mexErrMsgTxt(" ");
	}

/*  load matlab argument list and convert to integer (note that converting here
	and in the x-layer is inefficient, but it makes the x-layer more general)  */

	if (!mxIsNumeric(ADJMAT_IN) || (!mxIsEmpty(ADJMAT_IN) && !mxIsSparse(ADJMAT_IN))) {
		mexPrintf("%s -- Adjacency matrix must be numeric and sparse.\n",THISFUNCTION);
		mexErrMsgTxt(" ");
	}
	else {
		nvert =mxGetM(ADJMAT_IN);
		nedge2=mxGetNzmax(ADJMAT_IN);
		if (mxGetNzmax(ADJMAT_IN)) {
			ir    =mxGetIr(ADJMAT_IN);
			adjir = (int *) malloc(mxGetNzmax(ADJMAT_IN)*sizeof(int));
			for (i=0; i<mxGetNzmax(ADJMAT_IN); i++)
				adjir[i]=(int)ir[i];
		}
		if (mxGetN(ADJMAT_IN)) {
			jc    =mxGetJc(ADJMAT_IN);
			adjjc = (int *) malloc((mxGetN(ADJMAT_IN)+1)*sizeof(int));
			for (i=0; i<(mxGetN(ADJMAT_IN)+1); i++)
				adjjc[i]=(int)jc[i];
		}
		mexPrintf("%s -- Adjacency matrix is of size %d by %d with %d non-zeroes.\n",
				  THISFUNCTION,mxGetM(ADJMAT_IN),mxGetN(ADJMAT_IN),mxGetNzmax(ADJMAT_IN));
	}

	if (!mxIsNumeric(VERTLB_IN)) {
		mexPrintf("%s -- Vertex label vector must be numeric.\n",THISFUNCTION);
		mexErrMsgTxt(" ");
	}
	else {
		if (mxGetM(VERTLB_IN)*mxGetN(VERTLB_IN)) {
			vld=mxGetPr(VERTLB_IN);
			vli = (int *) malloc(mxGetM(VERTLB_IN)*mxGetN(VERTLB_IN)*sizeof(int));
			for (i=0; i<mxGetM(VERTLB_IN)*mxGetN(VERTLB_IN); i++)
				vli[i]=(int)vld[i];
		}
		mexPrintf("%s -- Vertex label vector is of size %d by %d.\n",
				  THISFUNCTION,mxGetM(VERTLB_IN),mxGetN(VERTLB_IN));
	}

	if (!mxIsNumeric(VERTWT_IN)) {
		mexPrintf("%s -- Vertex weight vector must be numeric.\n",THISFUNCTION);
		mexErrMsgTxt(" ");
	}
	else {
		if (mxGetM(VERTWT_IN)*mxGetN(VERTWT_IN)) {
			vwd=mxGetPr(VERTWT_IN);
			vwi = (int *) malloc(mxGetM(VERTWT_IN)*mxGetN(VERTWT_IN)*sizeof(int));
			for (i=0; i<mxGetM(VERTWT_IN)*mxGetN(VERTWT_IN); i++)
				vwi[i]=(int)vwd[i];
		}
		mexPrintf("%s -- Vertex weight vector is of size %d by %d.\n",
				  THISFUNCTION,mxGetM(VERTWT_IN),mxGetN(VERTWT_IN));
	}

	if (!mxIsNumeric(EDGEWT_IN) || (!mxIsEmpty(EDGEWT_IN) && !mxIsSparse(EDGEWT_IN))) {
		mexPrintf("%s -- Edge weight matrix must be numeric and sparse.\n",THISFUNCTION);
		mexErrMsgTxt(" ");
	}
	else {
		if (mxGetM(EDGEWT_IN)) {
			ewd=mxGetPr(EDGEWT_IN);
			ewi = (int *) malloc(mxGetM(EDGEWT_IN)*sizeof(int));
			for (i=0; i<mxGetNzmax(EDGEWT_IN); i++)
				ewi[i]=(int)ewd[i];
		}
		mexPrintf("%s -- Edge weight matrix is of size %d by %d with %d non-zeroes.\n",
				  THISFUNCTION,mxGetM(EDGEWT_IN),mxGetN(EDGEWT_IN),mxGetNzmax(EDGEWT_IN));
	}

	if (!mxIsChar(ARCHTYP_IN)) {
		mexPrintf("%s -- Architecture type must be character.\n",THISFUNCTION);
		mexErrMsgTxt(" ");
	}
	else {
		if (mxGetM(ARCHTYP_IN)*mxGetN(ARCHTYP_IN)) {
			archtyp = (char *) calloc(mxGetM(ARCHTYP_IN)*mxGetN(ARCHTYP_IN)+1,sizeof(char));
			mxGetString(ARCHTYP_IN,archtyp,mxGetM(ARCHTYP_IN)*mxGetN(ARCHTYP_IN)+1);
		}
		mexPrintf("%s -- Architecture type is \"%s\".\n",
				  THISFUNCTION,archtyp);
	}

	if (!mxIsNumeric(ARCHPAR_IN)) {
		mexPrintf("%s -- Architecture parameter vector must be numeric.\n",THISFUNCTION);
		mexErrMsgTxt(" ");
	}
	else {
		napar =mxGetM(ARCHPAR_IN)*mxGetN(ARCHPAR_IN);
		if (mxGetM(ARCHPAR_IN)*mxGetN(ARCHPAR_IN)) {
			apd=mxGetPr(ARCHPAR_IN);
			api = (int *) malloc(mxGetM(ARCHPAR_IN)*mxGetN(ARCHPAR_IN)*sizeof(int));
			for (i=0; i<mxGetM(ARCHPAR_IN)*mxGetN(ARCHPAR_IN); i++)
				api[i]=(int)apd[i];
		}
		mexPrintf("%s -- Architecture parameter vector is of size %d by %d.\n",
				  THISFUNCTION,mxGetM(ARCHPAR_IN),mxGetN(ARCHPAR_IN));
	}

	argcm=nrhs+1-REQ_ARGS;
	mexPrintf("argcm=%d\n",argcm);
	argvm = (char **) malloc(argcm*sizeof(char *));
	argvm[0] = (char *) calloc(4+1,sizeof(char));
	strcpy(argvm[0],"gmap");
	for (i=REQ_ARGS; i<nrhs; i++)
		if (!mxIsChar(prhs[i])) {
			mexPrintf("%s -- prhs[%d] must be character.\n",THISFUNCTION,i);
			mexErrMsgTxt(" ");
		}
		else {
			argvm[i+1-REQ_ARGS] = (char *) calloc(mxGetM(prhs[i])*mxGetN(prhs[i])+1,sizeof(char));
			mxGetString(prhs[i],argvm[i+1-REQ_ARGS],mxGetM(prhs[i])*mxGetN(prhs[i])+1);
		}
	for (i=0; i<argcm; i++)
		mexPrintf("argvm[%d]=\"%s\"\n",i,argvm[i]);

	/* Do the actual computations in a subroutine */

	mexPrintf("Gmapx:\n");
	ierr=gmapx(&maptabi,
			   argcm,
			   argvm,
			   nvert,
			   nedge2,
			   adjir,
			   adjjc,
			   vli,
			   vwi,
			   ewi,
			   archtyp,
			   napar,
			   api);
	mexPrintf("%s -- Error %d from Gmapx.\n",THISFUNCTION,ierr);

/*  for (i=0; i<nvert; i++)
		mexPrintf("maptabi[%d][0]=%d, maptabi[%d][1]=%d\n",
			 	  i,maptabi[i][0],i,maptabi[i][1]); */

	/* Create matrices for the return arguments */

	if (maptabi) {
		MAPTAB_OUT=mxCreateDoubleMatrix(nvert, 2, mxREAL);
		maptabd = mxGetPr(MAPTAB_OUT);
		k=0;
		for (j=0; j<2; j++)
			for (i=0; i<nvert; i++)
				maptabd[k++]=(double)maptabi[i][j];
		free(maptabi);
	}

	if (argvm)
		for (i=argcm-1; i>=0; i--)
			free(argvm[i]);
	if (api)     free(api);
	if (archtyp) free(archtyp);
	if (ewi)     free(ewi);
	if (vwi)     free(vwi);
	if (vli)     free(vli);
	if (adjjc)   free(adjjc);
	if (adjir)   free(adjir);

	RETURN_OUT=mxCreateDoubleMatrix(1, 1, mxREAL);
	*mxGetPr(RETURN_OUT)=ierr;

	return;
}

void GmapUsage( void )
{

    mexPrintf("\n");
    mexPrintf("Usage: [return,maptab]=Gmap_mex(adjmat,vertlb,vertwt,edgewt,archtyp,archpar,\n");
    mexPrintf("                                Scotch-specific parameters);\n");
    mexPrintf("\n");

    return;
}

