/*!\file IntInput.c
 * \brief: implementation of the IntInput object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./IntInput.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../DataSet/DataSet.h"
#include "../include/typedefs.h"
#include "../include/types.h"
#include "../include/macros.h"

/*Object constructors and destructor*/
/*FUNCTION IntInput::IntInput(){{{1*/
IntInput::IntInput(){
	return;
}
/*}}}*/
/*FUNCTION IntInput::IntInput(double* values){{{1*/
IntInput::IntInput(int in_enum_type,IssmInt in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION IntInput::~IntInput(){{{1*/
IntInput::~IntInput(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION IntInput::copy{{{1*/
Object* IntInput::copy() {
	
	return new IntInput(this->enum_type,this->value);

}
/*}}}*/
/*FUNCTION IntInput::DeepEcho{{{1*/
void IntInput::DeepEcho(void){

	printf("IntInput:\n");
	printf("   enum: %i\n",this->enum_type);
	printf("   %i\n",this->value);
}
/*}}}*/
/*FUNCTION IntInput::Demarshall{{{1*/
void  IntInput::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION IntInput::Echo {{{1*/
void IntInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION IntInput::Enum{{{1*/
int IntInput::Enum(void){

	return IntInputEnum;

}
/*}}}*/
/*FUNCTION IntInput::EnumType{{{1*/
int IntInput::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION IntInput::GetId{{{1*/
int    IntInput::GetId(void){ return -1; }
/*}}}*/
/*FUNCTION IntInput::GetName{{{1*/
char* IntInput::GetName(void){
	return "intinput";
}
/*}}}*/
/*FUNCTION IntInput::Marshall{{{1*/
void  IntInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of IntInput: */
	enum_type=IntInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall IntInput data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION IntInput::MarshallSize{{{1*/
int   IntInput::MarshallSize(){
	
	return sizeof(value)+
		sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum type
}
/*}}}*/
/*FUNCTION IntInput::MyRank{{{1*/
int    IntInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*Object functions*/

