/*!\file BoolInput.c
 * \brief: implementation of the BoolInput object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./BoolInput.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../DataSet/DataSet.h"
#include "../include/typedefs.h"
#include "../include/types.h"
#include "../include/macros.h"

/*Object constructors and destructor*/
/*FUNCTION BoolInput::BoolInput(){{{1*/
BoolInput::BoolInput(){
	return;
}
/*}}}*/
/*FUNCTION BoolInput::BoolInput(double* values){{{1*/
BoolInput::BoolInput(int in_enum_type,IssmBool in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION BoolInput::~BoolInput(){{{1*/
BoolInput::~BoolInput(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION BoolInput::copy{{{1*/
Object* BoolInput::copy() {
	
	return new BoolInput(this->enum_type,this->value);

}
/*}}}*/
/*FUNCTION BoolInput::DeepEcho{{{1*/
void BoolInput::DeepEcho(void){

	printf("BoolInput:\n");
	printf("   enum: %i\n",this->enum_type);
	printf("   %s\n",value?"true":"false");
}
/*}}}*/
/*FUNCTION BoolInput::Demarshall{{{1*/
void  BoolInput::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION BoolInput::Echo {{{1*/
void BoolInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION BoolInput::Enum{{{1*/
int BoolInput::Enum(void){

	return BoolInputEnum;

}
/*}}}*/
/*FUNCTION BoolInput::EnumType{{{1*/
int BoolInput::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION BoolInput::GetId{{{1*/
int    BoolInput::GetId(void){ return -1; }
/*}}}*/
/*FUNCTION BoolInput::GetName{{{1*/
char* BoolInput::GetName(void){
	return "boolinput";
}
/*}}}*/
/*FUNCTION BoolInput::Marshall{{{1*/
void  BoolInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of BoolInput: */
	enum_type=BoolInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall BoolInput data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION BoolInput::MarshallSize{{{1*/
int   BoolInput::MarshallSize(){
	
	return sizeof(value)+
		sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum type
}
/*}}}*/
/*FUNCTION BoolInput::MyRank{{{1*/
int    BoolInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*Object functions*/

