/*!\file Inputs.c
 * \brief: implementation of the Inputs object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./DataSet.h"
#include "./Inputs.h"

/*Object constructors and destructor*/
/*FUNCTION Inputs::Inputs(){{{1*/
Inputs::Inputs(){
	return;
}
/*}}}*/
/*FUNCTION Inputs::Inputs(int in_enum){{{1*/
Inputs::Inputs(int in_enum): DataSet(in_enum){
{
	//do nothing;
	return;
}
/*}}}*/
/*FUNCTION Inputs::~Inputs(){{{1*/
Inputs::~Inputs(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION Inputs::GetParameterValue(double* pvalue,double* gauss,int enum_type){{{1*/
void Inputs::GetParameterValue(double* pvalue,double* gauss, int enum_type){

	vector<Object*>::iterator object;
	Input* input=NULL;

	/*Go through inputs and check whether any input with the same name is already in: */
	for ( object=objects.begin() ; object < objects.end(); object++ ){

		input=(Input*)(*object); 
		if (input->EnumType()==enum_type)break;
	}

	if (!input){
		/*we could not find an input with the correct enum type. No defaults values were provided, 
		 * error out: */
		ISSMERROR("%s%i"," could not find input with enum type ",enum_type);
	}

	/*Ok, we have an input if we made it here, request the input to return the values: */
	input->GetParameterValues(pvalue,gauss);

}
/*}}}*/
/*FUNCTION Inputs::GetParameterValue(double* pvalue,double* gauss,int enum_type,double defaultvalue){{{1*/
void Inputs::GetParameterValue(double* pvalue,double* gauss, int enum_type,double defaultvalue){

	vector<Object*>::iterator object;
	Input* input=NULL;

	/*Go through inputs and check whether any input with the same name is already in: */
	for ( object=objects.begin() ; object < objects.end(); object++ ){

		input=(Input*)(*object); 
		if (input->EnumType()==enum_type)break;
	}

	if (!input){
		/*we could not find an input with the correct enum type. Return the default value: */
		*pvalue=defaultvalue;
	}
	else{
		input->GetParameterValue(pvalue,gauss);
	}
}
/*}}}*/
/*FUNCTION Inputs::GetParameterValues(double* values,double* gauss_pointers, int numgauss,int enum_type){{{1*/
void Inputs::GetParameterValues(double* values,double* gauss_pointers, int numgauss,int enum_type){

	vector<Object*>::iterator object;
	Input* input=NULL;

	/*Go through inputs and check whether any input with the same name is already in: */
	for ( object=objects.begin() ; object < objects.end(); object++ ){

		input=(Input*)(*object); 
		if (input->EnumType()==enum_type)break;
	}

	if (!input){
		/*we could not find an input with the correct enum type. No defaults values were provided, 
		 * error out: */
		ISSMERROR("%s%i"," could not find input with enum type ",enum_type);
	}

	/*Ok, we have an input if we made it here, request the input to return the values: */
	input->GetParameterValues(values,gauss_pointers,numgauss);

}
/*}}}*/
/*FUNCTION Inputs::GetParameterValues(double* values,double* gauss_pointers, int numgauss,int enum_type,double* defaultvalues){{{1*/
void GetParameterValues(double* values,double* gauss_pointers, int numgauss,int enum_type,double* defaultvalues){

	vector<Object*>::iterator object;
	Input* input=NULL;

	/*Go through inputs and check whether any input with the same name is already in: */
	for ( object=objects.begin() ; object < objects.end(); object++ ){

		input=(Input*)(*object); 
		if (input->EnumType()==enum_type)break;
	}

	if (!input){
		/*we could not find an input with the correct enum type. Return the default values: */
		for(i=0;i<numgauss;i++)values[i]=defaultvalues[i];
	}
	else{
		input->GetParameterValues(values,gauss_pointers,numgauss);
	}

}
/*}}}*/
/*FUNCTION Inputs::GetParameterValue(bool* pvalue,int enum-type){{{1*/
void GetParameterValue(bool* pvalue,int enum_type){

	vector<Object*>::iterator object;
	Input* input=NULL;

	/*Go through inputs and check whether any input with the same name is already in: */
	for ( object=objects.begin() ; object < objects.end(); object++ ){

		input=(Input*)(*object); 
		if (input->EnumType()==enum_type)break;
	}

	if (!input){
		/*we could not find an input with the correct enum type. No defaults values were provided, 
		 * error out: */
		ISSMERROR("%s%i"," could not find input with enum type ",enum_type);
	}

	/*Ok, we have an input if we made it here, request the input to return the value: */
	input->GetParameterValue(pvalue);

}
/*}}}*/
/*FUNCTION Inputs::GetParameterValue(int* pvalue,int enum-type){{{1*/
void GetParameterValue(int* pvalue,int enum_type){

	vector<Object*>::iterator object;
	Input* input=NULL;

	/*Go through inputs and check whether any input with the same name is already in: */
	for ( object=objects.begin() ; object < objects.end(); object++ ){

		input=(Input*)(*object); 
		if (input->EnumType()==enum_type)break;
	}

	if (!input){
		/*we could not find an input with the correct enum type. No defaults values were provided, 
		 * error out: */
		ISSMERROR("%s%i"," could not find input with enum type ",enum_type);
	}

	/*Ok, we have an input if we made it here, request the input to return the value: */
	input->GetParameterValue(pvalue);

}
/*}}}*/
/*FUNCTION Inputs::GetParameterValue(double* pvalue,int enum-type){{{1*/
void GetParameterValue(double* pvalue,int enum_type){

	vector<Object*>::iterator object;
	Input* input=NULL;

	/*Go through inputs and check whether any input with the same name is already in: */
	for ( object=objects.begin() ; object < objects.end(); object++ ){

		input=(Input*)(*object); 
		if (input->EnumType()==enum_type)break;
	}

	if (!input){
		/*we could not find an input with the correct enum type. No defaults values were provided, 
		 * error out: */
		ISSMERROR("%s%i"," could not find input with enum type ",enum_type);
	}

	/*Ok, we have an input if we made it here, request the input to return the value: */
	input->GetParameterValue(pvalue);

}
/*}}}*/
/*FUNCTION Inputs::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss,int enum_type){{{1*/
void Inputs::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss,int enum_type){

	vector<Object*>::iterator object;
	Input* input=NULL;

	/*Go through inputs and check whether any input with the same name is already in: */
	for ( object=objects.begin() ; object < objects.end(); object++ ){

		input=(Input*)(*object); 
		if (input->EnumType()==enum_type)break;
	}

	if (!input){
		/*we could not find an input with the correct enum type. No defaults values were provided, 
		 * error out: */
		ISSMERROR("%s%i"," could not find input with enum type ",enum_type);
	}

	/*Ok, we have an input if we made it here, request the input to return the value: */
	input->GetParameterValue(derivativevalues,xyz_list,gauss);
}
/*}}}*/
/*FUNCTION Inputs::GetStrainRate(double* epsilon,double* xyz_list, double* gauss, int xenum, int yenum){{{1*/
void Inputs::GetStrainRate(double* epsilon,double* xyz_list, double* gauss, int xenum, int yenum){

	vector<Object*>::iterator object;
	Input* xinput=NULL;
	Input* yinput=NULL;

	/*Go through inputs and find data for xenum: */
	for ( object=objects.begin() ; object < objects.end(); object++ ){
		xinput=(Input*)(*object); 
		if (xinput->EnumType()==xenum)break;
	}
	/*Go through inputs and find data for yenum: */
	for ( object=objects.begin() ; object < objects.end(); object++ ){
		yinput=(Input*)(*object); 
		if (yinput->EnumType()==yenum)break;
	}

	if (!xinput | !yinput){
		/*we could not find one input with the correct enum type. No defaults values were provided, 
		 * error out: */
		ISSMERROR("%s%i%s%i\n"," could not find input with enum type ",xenum," or enum type ",yenum);
	}

	/*Ok, we have the inputs, call bilinear operator: */
	xinput->GetStrainRate(epsilon,yinput,xyz_list,gauss);

}
/*}}}*/
/*FUNCTION Inputs::AddInput{{{1*/
int  Inputs::AddInput(Input* in_input){

	/*First, go through dataset of inputs and check whether any input 
	 * with the same name is already in. If so, erase the corresponding 
	 * object before adding this new one: */
	vector<Object*>::iterator object;
	Input* input=NULL;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		input=(Input*)(*object); 

		if (input->EnumType()==in_input->EnumType()){
			this->DeleteObject(input);
			break;
		}
	}
	this->AddObject(in_input);
}
/*}}}*/

/*Object functions*/
