/*! \file Vertex.h 
 *  \brief: header file for vertex object
 */

#ifndef _VERTEX_H_
#define _VERTEX_H_

class Object;
class DofObject;

#include "../ModelProcessorx/IoModel.h"
#include "./Object.h"
#include "./DofObject.h"

class Vertex: public Object,public DofObject{

	public: 

		int  id;
		double x;
		double y;
		double z;
		double sigma; //sigma coordinate: (z-bed)/thickness

		/*dof management: */
		int    clone;
		int    dof; //dof to recover values in a vertex indexed vector

		/*FUNCTION constructors, destructors {{{1*/
		Vertex();
		Vertex(int id, double x, double y, double z, double sigma); 
		void Init(int id, double x, double y, double z, double sigma);
		Vertex(int i, IoModel* iomodel);
		~Vertex();
		/*}}}*/
		/*FUNCTION object management {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   GetId(void); 
		char* GetName();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void  UpdateFromDakota(void* vinputs);
		void  UpdatePosition(double* thickness,double* bed);


		/*}}}*/
		/*FUNCTION DofObject routines {{{1*/
		void  DistributeDofs(int* pdofcount);
		void  OffsetDofs(int dofcount);
		void  ShowTrueDofs(int* borderdofs);
		void  UpdateCloneDofs(int* allborderdofs);
		void  SetClone(int* minranks);
		void  CreatePartition(Vec partition);
		/*}}}*/

};
#endif  /* _VERTEX_H */
