/*! \file DoubleInput.h 
 *  \brief: header file for triavertexinput object
 */

#include "./Input.h"
#include "../include/types.h"

#ifndef _DOUBLEINPUT_H_
#define _DOUBLEINPUT_H_

class DoubleInput: public Input{

	private: 
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		IssmDouble value;

	public:

		/*constructors, destructors: {{{1*/
		DoubleInput();
		DoubleInput(int enum_type,IssmDouble value);
		~DoubleInput();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   GetId(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();

		/*}}}*/
		/*numerics: {{{1*/
		/*}}}*/

};
#endif  /* _DOUBLEINPUT_H */
