/*!\file DoubleInput.c
 * \brief: implementation of the DoubleInput object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./DoubleInput.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../DataSet/DataSet.h"
#include "../include/typedefs.h"
#include "../include/types.h"
#include "../include/macros.h"

/*Object constructors and destructor*/
/*FUNCTION DoubleInput::DoubleInput(){{{1*/
DoubleInput::DoubleInput(){
	return;
}
/*}}}*/
/*FUNCTION DoubleInput::DoubleInput(double* values){{{1*/
DoubleInput::DoubleInput(int in_enum_type,IssmDouble in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION DoubleInput::~DoubleInput(){{{1*/
DoubleInput::~DoubleInput(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION DoubleInput::copy{{{1*/
Object* DoubleInput::copy() {
	
	return new DoubleInput(this->enum_type,this->value);

}
/*}}}*/
/*FUNCTION DoubleInput::DeepEcho{{{1*/
void DoubleInput::DeepEcho(void){

	printf("DoubleInput:\n");
	printf("   enum: %i\n",this->enum_type);
	printf("   %g\n",this->value);
}
/*}}}*/
/*FUNCTION DoubleInput::Demarshall{{{1*/
void  DoubleInput::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION DoubleInput::Echo {{{1*/
void DoubleInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DoubleInput::Enum{{{1*/
int DoubleInput::Enum(void){

	return DoubleInputEnum;

}
/*}}}*/
/*FUNCTION DoubleInput::EnumType{{{1*/
int DoubleInput::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION DoubleInput::GetId{{{1*/
int    DoubleInput::GetId(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleInput::GetName{{{1*/
char* DoubleInput::GetName(void){
	return "doubleinput";
}
/*}}}*/
/*FUNCTION DoubleInput::Marshall{{{1*/
void  DoubleInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of DoubleInput: */
	enum_type=DoubleInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall DoubleInput data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION DoubleInput::MarshallSize{{{1*/
int   DoubleInput::MarshallSize(){
	
	return sizeof(value)+
		sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum type
}
/*}}}*/
/*FUNCTION DoubleInput::MyRank{{{1*/
int    DoubleInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*Object functions*/

