/*
 * parallel.h: 
 */

#ifndef PARALLEL_H_
#define PARALLEL_H_

#include "../objects/objects.h"
#include "../io/io.h"

struct OptArgs;
class FemModel;

void gradjcompute_core(DataSet* results,Model* model);

void diagnostic_core(DataSet* results,Model* model);
void prognostic_core(DataSet* results,Model* model);
void prognostic2_core(DataSet* results,Model* model);
void balancedthickness_core(DataSet* results,Model* model);
void balancedthickness2_core(DataSet* results,Model* model);
void balancedvelocities_core(DataSet* results,Model* model);
void slopecompute_core(DataSet* results,Model* model);
void control_core(DataSet* results,Model* model);

void thermal_core(DataSet* results,Model* model);
void thermal_core_nonlinear(Vec* ptg,double* pmelting_offset,FemModel* fem,int analysis_type,int sub_analysis_type);

void steadystate_core(DataSet* results,Model* model);

void diagnostic_core_nonlinear(Vec* pug,Mat* pK_ff0,Mat* pK_fs0, DataSet* loads, FemModel* fem,int analysis_type,int sub_analysis_type);
void diagnostic_core_linear(Vec* ppg,FemModel* fem,int  analysis_type,int sub_analysis_type);
void convergence(int* pconverged, Mat K_ff,Vec p_f,Vec u_f,Vec u_f_old,DataSet* parameters);

void transient_core(DataSet* results,Model* model);
void transient_core_2d(DataSet* results,Model* model);
void transient_core_3d(DataSet* results,Model* model);

//int GradJOrth(WorkspaceParams* workspaceparams);

int GoldenSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*),FemModel* femmodel);

int BrentSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*),FemModel* femmodel);
	
double objectivefunctionC(double search_scalar,OptArgs* optargs);

int GradJSearch(double* search_vector,FemModel* femmodel,int step);
//int GradJCheck(WorkspaceParams* workspaceparams,int step,int status);

//int ParameterUpdate(double* search_vector,int step, WorkspaceParams* workspaceparams,BatchParams* batchparams);
void OutputResults(DataSet* results,char* filename);
void WriteLockFile(char* filename);

void ControlInitialization(Model* model);
void ControlRestart(Model* model,double* param_g);

void CreateFemModel(FemModel* femmodel,ConstDataHandle MODEL,int analysis_type,int sub_analysis_type);
//int BatchDebug(Mat* Kgg,Vec* pg,FemModel* femmodel,char* filename);
void ProcessResults(DataSet** pnewresults, DataSet* results,Model* model,int analysis_type);

#endif
