/*! \file IntInput.h 
 *  \brief: header file for triavertexinput object
 */

#include "./Input.h"
#include "../include/types.h"

#ifndef _INTINPUT_H_
#define _INTINPUT_H_

class IntInput: public Input{

	private: 
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		IssmInt value;

	public:

		/*constructors, destructors: {{{1*/
		IntInput();
		IntInput(int enum_type,IssmInt value);
		~IntInput();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   GetId(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();

		/*}}}*/
		/*numerics: {{{1*/
		/*}}}*/

};
#endif  /* _INTINPUT_H */
