/*!\file TriaVertexInput.c
 * \brief: implementation of the TriaVertexInput object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./TriaVertexInput.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../DataSet/DataSet.h"
#include "../include/typedefs.h"
#include "../include/macros.h"

/*Object constructors and destructor*/
/*FUNCTION TriaVertexInput::TriaVertexInput(){{{1*/
TriaVertexInput::TriaVertexInput(){
	return;
}
/*}}}*/
/*FUNCTION TriaVertexInput::TriaVertexInput(double* values){{{1*/
TriaVertexInput::TriaVertexInput(int in_enum_type,double* in_values){

	enum_type=in_enum_type;
	values[0]=in_values[0];
	values[1]=in_values[1];
	values[2]=in_values[2];
}
/*}}}*/
/*FUNCTION TriaVertexInput::~TriaVertexInput(){{{1*/
TriaVertexInput::~TriaVertexInput(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION TriaVertexInput::copy{{{1*/
Object* TriaVertexInput::copy() {
	
	return new TriaVertexInput(this->enum_type,this->values);

}
/*}}}*/
/*FUNCTION TriaVertexInput::DeepEcho{{{1*/
void TriaVertexInput::DeepEcho(void){

	printf("TriaVertexInput:\n");
	printf("   enum: %i\n",this->enum_type);
	printf("   %g|%g|%g\n",this->values[0],this->values[1],this->values[2]);
}
/*}}}*/
/*FUNCTION TriaVertexInput::Demarshall{{{1*/
void  TriaVertexInput::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&values,marshalled_dataset,sizeof(values));marshalled_dataset+=sizeof(values);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION TriaVertexInput::Echo {{{1*/
void TriaVertexInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION TriaVertexInput::Enum{{{1*/
int TriaVertexInput::Enum(void){

	return TriaVertexInputEnum;

}
/*}}}*/
/*FUNCTION TriaVertexInput::EnumType{{{1*/
int TriaVertexInput::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION TriaVertexInput::GetId{{{1*/
int    TriaVertexInput::GetId(void){ return -1; }
/*}}}*/
/*FUNCTION TriaVertexInput::GetName{{{1*/
char* TriaVertexInput::GetName(void){
	return "triavertexinput";
}
/*}}}*/
/*FUNCTION TriaVertexInput::Marshall{{{1*/
void  TriaVertexInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of TriaVertexInput: */
	enum_type=TriaVertexInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall TriaVertexInput data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&values,sizeof(values));marshalled_dataset+=sizeof(values);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION TriaVertexInput::MarshallSize{{{1*/
int   TriaVertexInput::MarshallSize(){
	
	return sizeof(values)+
		sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum type
}
/*}}}*/
/*FUNCTION TriaVertexInput::MyRank{{{1*/
int    TriaVertexInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*Object functions*/

