/*\file SlopeExtrude.c
 *\brief: extrude slope vertically, from bed upwards.
 */

#include "./SlopeExtrude.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	Vec      slope=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&SlopeExtrudeUsage);

	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTS,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODES,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADS,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALS,"DataSet",NULL);
	FetchData((void**)&slope,NULL,NULL,SLOPE,"Vector",NULL);

	/*!Call core code: */
	SlopeExtrudex(slope,elements,nodes,loads,materials);

	/*write output : */
	WriteData(SLOPEOUT,slope,0,0,"Vector",NULL);
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	VecFree(&slope);
	
	/*end module: */
	MODULEEND();

}

void SlopeExtrudeUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [slope] = %s(elements, nodes,loads, materials, slope);\n",__FUNCT__);
	_printf_("\n");
}
