/*!\file SlopeExtrudex
 * \brief: vertical velocity extrusion
 */

#include "./SlopeExtrudex.h"

#undef __FUNCT__ 
#define __FUNCT__ "SlopeExtrudex"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void SlopeExtrudex( Vec sg, DataSet* elements,DataSet* nodes, DataSet* loads, DataSet* materials){

	double* sg_serial=NULL;

	/*First, get elements and nodes configured: */
	elements->Configure(elements,loads, nodes, materials);
	nodes->Configure(elements,loads, nodes, materials);

	/*Serialize velcoity: */
	VecToMPISerial(&sg_serial,sg);

	/*Extrude velocity vertically: */
	elements->SlopeExtrude(sg,sg_serial);

	/*Assemble vector: */
	VecAssemblyBegin(sg);
	VecAssemblyEnd(sg);

	/*Free ressources:*/
	xfree((void**)&sg_serial);

}
