/*!\file: CreateConstraints.cpp
 * \brief general driver for creating constraints
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#undef __FUNCT__ 
#define __FUNCT__ "CreateConstraints"

#include "./Model.h"
#include "../shared/shared.h"

void CreateConstraints(DataSet** pconstraints, Model* model,ConstDataHandle model_handle){
	
	/*This is just a high level driver: */
	if ((strcmp(model->analysis_type,"diagnostic_horiz")==0)|| (strcmp(model->analysis_type,"control")==0)){
		CreateConstraintsDiagnosticHoriz(pconstraints,model,model_handle);
	}
	else if (strcmp(model->analysis_type,"diagnostic_vert")==0){
		CreateConstraintsDiagnosticVert(pconstraints,model,model_handle);
	}
	else if (strcmp(model->analysis_type,"diagnostic_stokes")==0){
		CreateConstraintsDiagnosticStokes(pconstraints,model,model_handle);
	}
	else if (strcmp(model->analysis_type,"diagnostic_hutter")==0){
		CreateConstraintsDiagnosticHutter(pconstraints,model,model_handle);
	}
	else if (strcmp(model->analysis_type,"slope_compute")==0){
		CreateConstraintsSlopeCompute(pconstraints,model,model_handle);
	}
	/*
	else if (strcmp(model->analysis_type,"melting")==0){
		CreateConstraintsMelting(pconstraints,model,model_handle);
	}
	else if (strcmp(model->analysis_type,"prognostic")==0){
		CreateConstraintsPrognostic(pconstraints,model,model_handle);
	}
	else if ((strcmp(model->analysis_type,"thermalsteady")==0) || (strcmp(model->analysis_type,"thermaltransient")==0)){
		CreateConstraintsThermal(pconstraints,model,model_handle);
	}*/
	else{
		throw ErrorException(__FUNCT__," analysis_type not supported yet!");
	}
}
