function md=balancedthickness(md)
%BALANCEDTHICKNESS - balancedthickness solution sequence.
%
%   Usage:
%      md=balancedthickness(md)

	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	models.analysis_type=BalancedthicknessAnalysisEnum; %needed for processresults
	
	displaystring(md.verbose,'%s',['reading balancedthickness model data']);
	md.analysis_type=BalancedthicknessAnalysisEnum; models.p=CreateFemModel(md);

	% figure out number of dof: just for information purposes.
	md.dof=modelsize(models);

	%initialize inputs
	displaystring(md.verbose,'\n%s',['setup inputs...']);
	inputs=inputlist;
	inputs=add(inputs,'vx',models.p.parameters.vx_g,'doublevec',1,models.p.parameters.numberofvertices);
	inputs=add(inputs,'vy',models.p.parameters.vy_g,'doublevec',1,models.p.parameters.numberofvertices);
	inputs=add(inputs,'thickness',models.p.parameters.h_g,'doublevec',1,models.p.parameters.numberofvertices);
	inputs=add(inputs,'dhdt',models.p.parameters.dhdt_g,'doublevec',1,models.p.parameters.numberofvertices);
	inputs=add(inputs,'melting',models.p.parameters.m_g,'doublevec',1,models.p.parameters.numberofvertices);
	inputs=add(inputs,'accumulation',models.p.parameters.a_g,'doublevec',1,models.p.parameters.numberofvertices);

	displaystring(md.verbose,'\n%s',['call computational core:']);
	results=balancedthickness_core(models,inputs,BalancedthicknessAnalysisEnum(),NoneAnalysisEnum());

	displaystring(md.verbose,'\n%s',['load results...']);
	if ~isstruct(md.results), md.results=struct(); end
	md.results.balancedthickness=processresults(models,results);

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);	
