#!/bin/csh -f 

# Checkout Dakota and create tarball(s) to use for builds on other platforms
# and various web pushes.  By default, tarball(s) will be created in the 
# directory $DAKOTA_ROOT/nightly/tarballs
# 
# --- external arguments/variables used ---
# $1 DAKOTA_ROOT, e.g., /usr/sharelan/dakota on SCICO, /Net/dakota in CSRI, 
#                       /projects/dakota on SNL clusters
# $2 version or other tag for source tarball(s) created (e.g. votd, 4_0)
# $3 SVN revision of Dakota to checkout (trunk, tags/Version_4_1)
# $4 optional: distribution tarballs to build (default int_full, int_web,
#                                                      ext_web)
#    1: ext            (omits NLPQL, DOT, NPSOL) [base]
#    2: int_web        (omits DOT)               [base + NPSOL + NLPQL]
#    4: int_supervised (all packages)            [base + NPSOL + NLPQL + DOT]
#    8: int_full       (full repository checkout for nightly testing) 
#    This is bit-wise: add any of these to create multiple tarballs
#
# $DEV_SVNROOT (needed by extract_src.csh:checkout_script.csh)
# $DAKOTA_TARS:  by default the destination dir for tarballs will be
#                $DAKOTA_ROOT/nightly/tarballs.  If this environment variable
#                is already set before entering this script, this will be
#                the destination directory. 
# -----------------------------------------

# -------------------------------
# required command-line arguments
# -------------------------------
if ( $#argv < 3 ) then
  echo "${0}: Incorrect usage; see script for options"
  exit
endif

echo "Running $0 on `uname -n` at `date`"

setenv DAKOTA_ROOT $1
setenv TEST_SQA $DAKOTA_ROOT/Dakota/test/sqa
source $TEST_SQA/environment.csh
set TAR_TAG = $2
set DAKOTA_VER = $3

# ---------------------------------
# command-line option: distribution
# ---------------------------------
if ( $#argv > 3 ) then
  set DISTRO = $4 
  if ( $DISTRO < 1 || $DISTRO > 15 ) then
    echo "Invalid DISTRO option $DISTRO specified. Exiting."
    exit
  endif
else 
  echo "Using default: int_full, int_web, ext_web distributions."
  set DISTRO = 11
endif

if ( ${?DAKOTA_TARS} == 0 ) then
  setenv DAKOTA_TARS $DAKOTA_ROOT/nightly/tarballs
endif

echo "*** Begin $0 to create nightly Dakota source tarball(s) in directory $DAKOTA_TARS ***"

# explicitly cleanup .tar, .tar.gz, .tgz
mkdir -p $DAKOTA_TARS
cd $DAKOTA_TARS
\rm -f Dakota_${TAR_TAG}*.src.tar
\rm -f Dakota_${TAR_TAG}*.src.tar.gz
\rm -f Dakota_${TAR_TAG}*.src.tgz

# First create tar in /tmp to avoid NFS problems
mkdir -p /tmp/nightly_tar
cd /tmp/nightly_tar
rm -rf *

# perform an svn _export_ and create src tarballs
$TEST_SQA/extract_src.csh $TAR_TAG $DAKOTA_VER $DISTRO >&! extract_src.log

foreach tarfile ( `ls Dakota_${TAR_TAG}*.src.tar` )
  echo "gzipping $tarfile"
  gzip $tarfile
end
mv -f * $DAKOTA_TARS
cd /tmp
rm -rf nightly_tar

echo "*** ${0}: nightly Dakota source tarball(s) complete ***"

# cannot do the following yet due to difference in acro vs. others
#cd $DAKOTA_TARS
#mkdir -p packages
#$TEST_SQA/checkout_script.csh $DAKOTA_TARS/packages packages checkout
#tar cf packages.tar packages
#gzip packages.tar
