#!/bin/csh -f
#
# This (misnamed) script installs VOTD or release binaries on internal
# platforms and distributes to external and internal web pages
#
# --- external variables used ---
# $1 distro  (types enabled in build -- see run_base_test or extract_src)
# $2 tar_tag (for binary tarballs: votd, 4_0)
# $DAKOTA_ROOT       target directory for internal binaries
# $TEST_DIR_FQ       (run_base_test.csh)
# $TEST_PLATFORM     short name of test platform (environment.csh)
# $TEST_PLATFORM_VER (environment.csh)
# $SNLSYSTEM         (environment.csh)
# -------------------------------

if ( $SNLSYSTEM == 'csri' ) then
  # Push from dakmacppc 
  echo "Pushing MAC OS X from dakmacpcc"
  set stable_web yes
  set stable_install no
else if ( $SNLSYSTEM == 'scico' ) then
  set stable_web yes
  set stable_install yes
else
  echo "Distribution push currently enabled for 'scico' and 'csri' only."
  set stable_web no
  set stable_install no
  exit
endif

if ( $#argv < 2 ) then
  echo "Usage: $0 distro tar_tag"
  exit
endif

echo "Running $0 on `uname -n` at `date`"

set distro   = $1
set tar_tag  = $2
set bin_tars = $TEST_DIR_FQ/bin_tars

# SCICO install (int_full, DAKOTA_ROOT = /usr/sharelan/dakota)
# Capacity clusters install (DAKOTA_ROOT = /projects/dakota)
#
# (These were previously based on int_supervised, but the only
# difference between that and int_full was dakota_library_mode binary,
# so we're currently using int_full and not performing the
# int_supervised build.)
#
# BUT! tests have been run in int_full directory, so use the
# archived tarball to do the installation!
#
# TO DO:  add Capacity clusters to votd; need to modify cluster
#         installation to include an 'install' directory instead
#         of the way it is now.  Also, $TEST_PLATFORM will be a problem
#         since linux64 is too general (both tbird and spirit, e.g.)
if ( $distro & 4 ) then

  set distro_name = int_full
  set dak_src  = $bin_tars/$distro_name
  set dak_dest = $DAKOTA_ROOT/install/$TEST_PLATFORM/votd
  # check for errors
  if ( -e $TEST_DIR_FQ/${distro_name}_reconfig_dakota.err || \
       -e $TEST_DIR_FQ/${distro_name}_config_dakota.err ||   \
       -e $TEST_DIR_FQ/${distro_name}_make_dakota.err ||     \
       ! -e $dak_src/bin/dakota ) then
    echo "$SNLSYSTEM (${distro_name}) build failed" 
  else
    # copy full distribution as installed to bin_tars (using tarball)
    # be careful and use explicit paths in case $dak_dest is wrong
    # this will fail if the tarball contains Dakota/Dakota (doesn't now)
    set dak_src_tar  = $bin_tars/Dakota_votd_${distro_name}.tar.gz
    echo "$SNLSYSTEM (${distro_name}) install from $dak_src_tar to $dak_dest"
    rm -rf $dak_dest/*
    set save_dir = `pwd`
    cd $dak_dest
    gunzip -c $dak_src_tar | tar xf -
    mv $dak_dest/Dakota/* $dak_dest
    rm -rf $dak_dest/Dakota
    cd $save_dir
    echo "$SNLSYSTEM (${distro_name}) install complete" 
  endif
endif  #-- end int_full push --#  

# iterate over potential external, internal web distributions, checking against
# distro to see if needed
if ( ( $SNLSYSTEM != 'csri' ) && ( $SNLSYSTEM != 'scico' ) ) then
  echo "VOTD/stable web push from 'csri' and 'scico' only"
  exit
endif
 
foreach webdist ( 1 2 ) 
if ( $distro & $webdist ) then

  if ( $webdist == 1 ) then
    set distro_name = ext_web
    set web_serv = www.sandia.gov
    set web_path = /vhosts/www.cs/DAKOTA/licensing
  else
    set distro_name = int_web
    set web_serv = development.sandia.gov
    set web_path = /home/dakota/public_html/licensing
  endif

  if ( $tar_tag == 'votd' ) then 
    set web_path = "${web_path}/votd"
    set doc_tag = _votd
  else
    set web_path = "${web_path}/release"
    set doc_tag = `echo $tar_tag | tr '_' '.'`
  endif

  set dak_src = $bin_tars/$distro_name
  set web_fq = "${web_serv}:$web_path"
 
  set fail_push = 0  #Want to check error return from scp; currently having problems using $? on some platforms

  # check for errors
  if ( -e $TEST_DIR_FQ/${distro_name}_reconfig_dakota.err || \
       -e $TEST_DIR_FQ/${distro_name}_config_dakota.err ||   \
       -e $TEST_DIR_FQ/${distro_name}_make_dakota.err ||     \
       ! -e $dak_src/bin/dakota ) then
    echo "create_votd.csh: ${distro_name} build failed" 
  else
    echo "create_votd.csh: ${distro_name} push to $web_fq"
    scp -Bp $bin_tars/Dakota_${tar_tag}_${distro_name}.tar.gz $web_fq/Dakota_${tar_tag}.$TEST_PLATFORM_VER.tar.gz

    # Linux only: push VOTD src/HTML distributions to www and extract HTML
    if ( $TEST_PLATFORM == 'linux64' ) then
      # sources
      setenv DAKOTA_TARS /usr/sharelan/dakota/nightly/tarballs
      scp -Bp $DAKOTA_TARS/Dakota_${tar_tag}_${distro_name}.src.tar.gz $web_fq/Dakota_${tar_tag}.src.tar.gz
      set fail_push = $?
      if ( $fail_push != 0 ) then
        # error scp to web
        echo "Failed VOTD push of src tar to $web_fq"
      endif
      # documentation (only external for now)
      if ( $webdist == 1) then
        scp -B $bin_tars/html-dev${doc_tag}.tgz $web_fq/.
        scp -B $bin_tars/html-ref${doc_tag}.tgz $web_fq/.
        scp -B $bin_tars/Users${doc_tag}.pdf       $web_fq/.
        ssh $web_serv "cd $web_path; \rm -rf html-dev html-ref; tar xzf html-dev${doc_tag}.tgz; tar xzf html-ref${doc_tag}.tgz; \chgrp -R cs *; \chmod -R g+w *"
      endif
    endif 

    if ( $tar_tag == 'votd' ) then
     if ( $fail_push == 0) then
      echo "$webdist VOTD creation and push succeeded"
      # Update timestamps on the tarball links in the VOTD download page.
      set bdate = "<b>updated `date '+%D'`</b>"
      scp -B $web_fq/../download_votd.html .
      sed "s@\(,\)\(.*\)\().*$TEST_PLATFORM\)@\1 $bdate\3@" download_votd.html > t.html
      mv t.html download_votd.html
      scp -B download_votd.html $web_fq/../download_votd.html

      # stable release
      # push VOTD tarball to stable if no test failures
      # (allow FAIL consistent with baseline)

      # Parse serial and possibly parallel tests
      set test_prefix = "$TEST_DIR_FQ/int_full"
      set fail = `grep FAIL ${test_prefix}_dakota_diffs.out | grep -c -v 'consistent with baseline'`
      set pfail = 0
      if ( $TEST_PARALLEL == 'yes' ) then
        set pfail = `grep FAIL ${test_prefix}_dakota_pdiffs.out | grep -c -v 'consistent with baseline'`
      endif
      if ( -e ${test_prefix}_dakota_diffs.out && $fail == 0  &&  $pfail == 0 && -e ${test_prefix}_dakota_pdiffs.out ) then
        echo "Pushing ${distro_name} to stable for platform $TEST_PLATFORM."
	# copy binary from votd to stable
	ssh $web_serv "cd $web_path/..; \cp -f votd/Dakota_votd.$TEST_PLATFORM_VER.tar.gz stable/Dakota_stable.$TEST_PLATFORM_VER.tar.gz"

        # Linux copy src, possibly docs from VOTD to stable 
        if ( $TEST_PLATFORM == 'linux64' ) then
	  if ( $webdist == 1 ) then
  	    # src and docs on external
            ssh $web_serv "cd $web_path/..; \cp -f votd/Dakota_votd.src.tar.gz stable/Dakota_stable.src.tar.gz; \cp -f votd/Users_votd.pdf stable/Users_stable.pdf; cp -rf votd/html-ref stable/; cp -rf votd/html-dev stable/; cp -f votd/html-ref_votd.tgz stable/html-ref_stable.tgz; cp -f votd/html-dev_votd.tgz stable/html-dev_stable.tgz;"
	  else
	    # src only on internal
            ssh $web_serv "cd $web_path/..; \cp -f votd/Dakota_votd.src.tar.gz stable/Dakota_stable.src.tar.gz;"
	  endif
        endif
        # Update timestamps on the tarball links in the stable download page.
        set bdate = "<b>updated `date '+%D'`</b>"
        scp -B $web_fq/../download_stable.html .
        sed "s@\(,\)\(.*\)\().*$TEST_PLATFORM\)@\1 $bdate\3@" download_stable.html > t.html
        mv t.html download_stable.html
        scp -B download_stable.html $web_fq/../download_stable.html
        echo "Stable push from votd completed"
      else
        echo "Unexpected failures or no serial test results; not distributing stable"
      endif # end stable push
     endif
    endif # votd-specific updates
  endif # successful web push

endif #-- end if web push needed --#
end #-- end for loop over ext/int --#
