/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:       MergedConstraints
//- Description: Container class of linear constraints and bounds employing 
//-              the "merged" approach to variables usage.
//- Owner:       Mike Eldred
//- Version: $Id: MergedConstraints.H 5793 2009-03-31 03:15:00Z mseldre $

#ifndef MERGED_CONSTRAINTS_H
#define MERGED_CONSTRAINTS_H

#include "DakotaConstraints.H"
#include "DataVariables.H"


namespace Dakota {

/// Derived class within the Constraints hierarchy which employs
/// the merged data view.

/** Derived variable constraints classes take different views of the
    design, uncertain, and state variable types and the continuous and
    discrete domain types.  The MergedConstraints derived class
    combines continuous and discrete domain types but separates
    design, uncertain, and state variable types.  The result is merged
    design bounds arrays (mergedDesignLowerBnds,
    mergedDesignUpperBnds), uncertain distribution bounds arrays
    (uncertainLowerBnds, uncertainUpperBnds), and merged state
    bounds arrays (mergedStateLowerBnds, mergedStateUpperBnds).  The
    branch and bound strategy uses this approach (see
    Variables::get_variables(problem_db) for variables type
    selection; variables type is passed to the Constraints
    constructor in Model). */

class MergedConstraints: public Constraints
{
public:

  //
  //- Heading: Constructor and destructor
  //

  /// default constructor
  MergedConstraints();
  /// standard constructor
  MergedConstraints(const ProblemDescDB& problem_db,
		    const pair<short,short>& view,
		    const Sizet2DArray& vars_comps);
  /// destructor
  ~MergedConstraints();

  //
  //- Heading: Virtual function redefinitions
  //

  void write(ostream& s) const;
  void read(istream& s);

protected:

  //
  //- Heading: Virtual function redefinitions
  //

  void copy_rep(const Constraints* con_rep);
  void reshape_rep();

  void build_active_views();
  void build_inactive_views();

private:

  //
  //- Heading: Convenience functions
  //
};


inline MergedConstraints::MergedConstraints()
{ }


inline MergedConstraints::~MergedConstraints()
{ }

} // namespace Dakota

#endif
