/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Description: Singleton storage class for Subversion revision, build
//-              time and date; referenced via getInstance() from clients.
//- 
//- Owner:       Shannon Brown
//- Checked by:
//- Version: $Id$

#include "DakotaString.H"

namespace Dakota {

class DakotaBuildInfo
{
public:
  // Default constructor
  DakotaBuildInfo();

  // Method for getting the instance
  static DakotaBuildInfo& getInstance();

  // Getter member functions
  String getRev();
  String getDate();
  String getTime();

private:
  String rev;
  String date;
  String time;
};

}
