/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:       AllVariables
//- Description: Container class of variables, employing the "all" approach to
//-              variables usage.
//- Owner:       Mike Eldred
//- Version: $Id: AllVariables.H 5793 2009-03-31 03:15:00Z mseldre $

#ifndef ALL_VARIABLES_H
#define ALL_VARIABLES_H

#include "DakotaVariables.H"


namespace Dakota {

/// Derived class within the Variables hierarchy which employs
/// the all data view.

/** Derived variables classes take different views of the design,
    uncertain, and state variable types and the continuous and
    discrete domain types.  The AllVariables derived class combines
    design, uncertain, and state variable types but separates
    continuous and discrete domain types.  The result is a single
    array of continuous variables (allContinuousVars) and a single
    array of discrete variables (allDiscreteVars).  Parameter and DACE
    studies currently use this approach (see
    Variables::get_variables(problem_db)). */

class AllVariables: public Variables
{
public:

  //
  //- Heading: Constructors and destructor
  //

  /// default constructor
  AllVariables();
  /// standard constructor
  AllVariables(const ProblemDescDB& problem_db, const pair<short,short>& view);
  /// destructor
  ~AllVariables();

  //
  //- Heading: Virtual function redefinitions
  //

  void read(istream& s);
  void write(ostream& s) const;
  void write_aprepro(ostream& s) const;

  void read_annotated(istream& s);
  void write_annotated(ostream& s) const;

  void write_tabular(ostream& s) const;

  void read(BiStream& s);
  void write(BoStream& s) const;

  void read(MPIUnpackBuffer& s);
  void write(MPIPackBuffer& s) const;

protected:

  //
  //- Heading: Virtual function redefinitions
  //

  void copy_rep(const Variables* vars_rep);
  void reshape_rep(const Sizet2DArray& vars_comps);

  void build_active_views();
  void build_inactive_views();

private:

  //
  //- Heading: Private member functions
  //
};


inline AllVariables::AllVariables()
{ }


inline AllVariables::~AllVariables()
{ }


inline void AllVariables::build_inactive_views()
{
  //icvStart = idvStart = numICV = numIDV = 0;
  Cerr << "Error: inactive view must be EMPTY in AllVariables." << endl;
  abort_handler(-1);
}


inline void AllVariables::copy_rep(const Variables* vars_rep)
{ build_views(); }

} // namespace Dakota

#endif
