/*********************************************************************
Copyright 2008 Sandia Corporation.  Under the terms of Contract
DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government
retains certain rights in this software.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

* Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

* Neither the name of Sandia Corporation nor the names of its
contributors may be used to endorse or promote products derived from
this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
***********************************************************************/

/* dakreorder.c */

#include <stdio.h>
#include <string.h>

extern void nidr_parse(const char*, FILE*);
extern FILE *nidrin;

char nidr_please_refer[] =
	"Please refer to the DAKOTA Reference and/or User's Manual or the\n"
	"dakota.input.txt file distributed with this executable.";

 static char *progname;

 static int
usage(int rc)
{
	fprintf(rc ? stderr : stdout, "Usage: %s [options] [infile [outfile]]\n\
	to reorder DAKOTA input file infile (or stdin if infile is not given)\n\
	to an order that permits simple parsing, with abbreviated keywords\n\
	expanded to their full forms.\nOptions:\n\
	-1 ==> put data for a keyword on one line\n\
	-c ==> retain comments\n\
	-p ==> replace aliases by the \"preferred\" name\n", progname);
	return rc;
	}

 int
main(int argc, char **argv)
{
	FILE *f;
	char buf[8], *b, *s;
	int comkeep, oneline, prefer;

	progname = *argv;
	comkeep = oneline = prefer = 0;
nextarg:
	while((s = *++argv) && *s == '-') {
		for(;;)
			switch(*++s) {
			  case 0: goto nextarg;
			  case '1': ++oneline; continue;
			  case 'c': ++comkeep; continue;
			  case 'p': ++prefer;  continue;
			  case 'h': return usage(!s[1] || !strcmp(s,"help") ? 0 : 1);
			  case '?': return usage(s[1] != 0);
			  case '-': if (!s[1]) {
					s = *++argv;
					goto optsdone;
					}
				if (!strcmp(s,"-help"))
					return usage(0);
			  default:  return usage(1);
			  }
		}
 optsdone:
	/* default nidrin (set by nidr-scanner) is stdin */
	f = stdout;
	if (s) {
		if (argv[1] && argv[2])
			return usage(1);
		if (!(nidrin = fopen(s,"r"))) {
			fprintf(stderr, "%s: Cannot open input file \"%s\"\n",
				progname, s);
			return 1;
			}
		if ((b = argv[1]) && !(f = fopen(b, "w"))) {
			fprintf(stderr, "%s: Cannot open output file \"%s\"\n", progname, b);
			return 1;
			}
		}
	b = buf;
	if (oneline + comkeep + prefer) {
		*b++ = '-';
		if (oneline)
			*b++ = '1';
		if (comkeep)
			*b++ = 'c';
		if (prefer)
			*b++ = 'p';
		*b = 0;
		}
	nidr_parse(buf, f);
	return 0;
	}

#include "nidr.h"

 static void
dummystart(const char *kwname, Values *val, void **g, void *v)
{}
#include "NIDR_keywds0.h"
