// $Id: APPSPACK_Citizen_NAPPSListener.hpp,v 1.2 2008/05/02 00:57:23 tgkolda Exp $ 
// $Source: /usr/local/cvsroot/hopspack/src/APPSPACK_Citizen_NAPPSListener.hpp,v $ 

//@HEADER
// ************************************************************************
// 
//         HOPSPACK: Hybrid Opitmization Parallel Search Package
//               Copyright (2008) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//                                                                                 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.                                                                           .
// 
// Questions? Contact Tammy Kolda (tgkolda@sandia.gov) 
// 
// ************************************************************************
//@HEADER

/*!
  \file APPSPACK_Citizen_NAPPSListener.hpp
  \brief Class definition for APPSPACK::Citizen_NAPPSListener
*/

#ifndef APPSPACK_CITIZEN_NAPPSLISTENER_HPP
#define APPSPACK_CITIZEN_NAPPSLISTENER_HPP

#include "APPSPACK_ConveyorList.hpp"
#include "APPSPACK_Citizen_Interface.hpp"
#include "APPSPACK_Parameter_List.hpp"
#include "APPSPACK_Constraints_Linear.hpp"
#include "APPSPACK_List.hpp"
#include <time.h>

namespace APPSPACK
{

//! Namespace for algorithms that generate points to be evaluated by Conveyor.  
namespace Citizen
{
  
// Calls merely listens and record points.
  class NAPPSListener : public Interface
{
public:
  //! Constructor.
  NAPPSListener(Parameter::List& params, const Constraints::Linear& constraints,
           Combiner::Generic& combiner, const string name);

  //! Destructor.
  ~NAPPSListener();

  //! Called once by mediator prior to processing points for any citizen.
  virtual void preprocess();
  
  //! Called once by mediator when point processing by all citizens complete.
  virtual void postprocess();
  
  //! Take in list of evaluated appspacks. Give list of new points.
  virtual void exchange(const ConveyorList& R, ConveyorList& Wnew, 
                        const map<string, vector<int> >& ownermap);
  
  //! Vote on points to be evaluated.
  virtual void vote(const ConveyorList& W, 
		    const map<string, vector<int> >& ownermap, 
		    vector<int>& tagOrder);
  
  //! Returns the Citizen's current state.
  virtual Citizen::State getState();
  
  //! Returns Citizens name.
  virtual const string& getName() const;

  //! Must be defined by Citizen if one or more processors requested.
  virtual bool worker();

private:

  //! Returns infinity norm of all but first elements of fc
  double infnorm(APPSPACK::Vector fc);

private:

  //! Name of this Citizen.
  string name;

  //! Dummy default combiner;
  APPSPACK::Combiner::Generic combiner;

  //! Parameters file.
  Parameter::List& params;

  //! Output stream to store results.
  ofstream resultsStream;

  //! Output file name.
  string resultsFile;

  //! Best x point found so far.
  Vector xBest;

  //! Objective value of best f(x) wrt constraint tolerance.
  Vector fcBest;

  //! Tag of best point.
  int bestTag;

  //! Evaluation count.
  int evalCount;

  //! Initial start time;
  time_t startTime;

  //! Constraint violation tolerance.
  double etaStar;

  //! If true, consistently resubmit current best point.
  bool resubmitBest;

  //! Number of linear equality constraints.
  int nlec;

  //! Number of linear inequality constraints.
  int nlic;

};

}
}

//! Outputs stream state.
ostream& operator<<(ostream& stream, APPSPACK::Citizen::State state);

#endif
