//@HEADER
// ************************************************************************
// 
//         HOPSPACK: Hybrid Opitmization Parallel Search Package
//               Copyright (2008) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//                                                                                 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.                                                                           .
// 
// Questions? Contact Tammy Kolda (tgkolda@sandia.gov) 
// 
// ************************************************************************
//@HEADER

/*!
  \file APPSPACK_Citizen_Generator.hpp
  \brief Class definition for APPSPACK::Citizen_Generator
*/

#ifndef APPSPACK_CITIZEN_GENERATOR_HPP
#define APPSPACK_CITIZEN_GENERATOR_HPP

#include "APPSPACK_Parameter_List.hpp"
#include "APPSPACK_Citizen_Interface.hpp"
#include "APPSPACK_Combiner_Generic.hpp"
#include "APPSPACK_Constraints_Linear.hpp"

namespace APPSPACK
{

namespace Citizen
{

//! A customizable class used to generate citizens.
class Generator
{
public:

  //! Constructor 
  Generator();
  
  //! Destructor
  ~Generator();

  //! Creates new instance of a Citizen of given type and name.
  /*!
    \param params (input) Citizen's parameters
    \param linear (input) Citizen's constraints
    \param combiner (input) Citizen's combiner used for generating points
    \param type (input) gives citizen type 
    \param name (input) gives citizen name
    \param workerRank (input) provides ranks of processors owned by citizen.
  */
  virtual Citizen::Interface* newCitizenType(Parameter::List& params,
                                             Constraints::Linear& linear,
                                             Combiner::Generic& combiner,
                                             const string& type, const string& name,                                     
                                             const vector<int>& workerRank);
private:

};

}
}
#endif
