//@HEADER
// ************************************************************************
// 
//         HOPSPACK: Hybrid Opitmization Parallel Search Package
//               Copyright (2008) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//                                                                                 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.                                                                           .
// 
// Questions? Contact Tammy Kolda (tgkolda@sandia.gov) 
// 
// ************************************************************************
//@HEADER

/*!
  \file NAPPSPACK_Filter.hpp
  \brief Class description for NAPPSPACK::Filter
*/

#ifndef NAPPSPACK_FILTER
#define NAPPSPACK_FILTER

#include "APPSPACK_Common.hpp"
#include "APPSPACK_Vector.hpp"

namespace NAPPSPACK
{

/*! \brief
  Class which stores best function values encounter so far for differing levels
  of constraint function evaluation.  That is, this class stores the best function 
  value for constraint violations less than \f$10^e\f$ where \f$e\f$ satisfies
  \f$e_s \le e \le e_b\f$.
*/
class Filter
{
public:
  //! Constructor. 
  Filter(int esmall, int ebig);
  //! Insert a new function value into approriate place.
  void insert(const APPSPACK::Vector& x, const APPSPACK::Vector& fc);
  //! Prints contents of filter.
  void print();
  //! Get best function value with constraint violation less than \f$10^{-d}\f$.
  bool getBest(int d, APPSPACK::Vector& xbest, APPSPACK::Vector& fcbest);
private:
  //! Computes the one norm of \f$c\f$ where \f$fc = [f,c^{T}]^{T}.\f$
  double onenorm(const APPSPACK::Vector& fc);
private:
  //! Stores the discrete filter of best function values.
  map<int, pair<APPSPACK::Vector,APPSPACK::Vector> > filter;
  //! Stores iterator to be used with filter.
  map<int, pair<APPSPACK::Vector,APPSPACK::Vector> >::iterator iter;
  //! \f$10^{\rm es}\f$ denotes smallest constraint violation stored.
  const int es;
  //! \f$10^{\rm eb}\f$ dentoes largest constraint violation stored.
  const int eb;
};


}
#endif
