/*  _________________________________________________________________________
 *
 *  Coliny: A Library of COLIN optimizers
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top Coliny directory.
 *  _________________________________________________________________________
 */

/**
 * \file DOT.h
 *
 * Defines the coliny::DOT_CG class.
 */

#include <acro_config.h>
#if 0

#ifndef COLINY_WITHOUT_DOT

#ifndef coliny_DOT_h
#define coliny_DOT_h

#include <colin/ColinSolver.h>


namespace coliny {

/** An interface to the DOT Conjugate Gradient algorithm.
*/
class DOT_CG : public colin::OptSolver<vector<double> >
{
public:

  ///
  DOT_CG();

  ///
  void reset();

  ///
  void minimize();

protected:

  ///
  void initialize_best_point()
	{
	if ((best_point.size() > 0) &&
	    (best_point.size() != problem.num_real_params()))
	   EXCEPTION_MNGR(runtime_error, "initialize_best_point - user-provided best point has length " << best_point.size() << " but the problem size is " << problem.num_real_params() << endl)
        best_point.resize(problem.num_real_params());
	}

  ///
  double ftol;

  ///
  double fdss;

  ///
  int numConstraints;
 
  ///
  int dotInfo;

  ///
  int dotFDSinfo;

  ///
  int dotMethod;

  ///
  int printControl;

  ///
  int optimizationType;

  ///
  vector<double> realWorkSpace;

  ///
  vector<int>  intWorkSpace;

  ///
  vector<double> constraintArray;
 
  ///
  vector<double> realCntlParmArray;

  ///
  vector<int> intCntlParmArray;

  ///
  vector<double> X;

  ///
  vector<double> bestX;

  ///
  vector<double> lowerBoundsArray;

  ///
  vector<double> upperBoundsArray;

};

} // namespace coliny

#endif

#endif

#endif
