/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

/**
 * \file TestOptSolver.h
 *
 * Defines TestOptSolver, a class that defines a simple solver
 * for exercising COLIN.
 */

#include <acro_config.h>
#include <utilib/stl_auxillary.h>
#include <colin/colin.h>
#include <colin/StdOptSolver.h>

using namespace colin;


class TestOptSolver : public OptSolver<std::vector<double> >
{
public:

  TestOptSolver() {}
  virtual ~TestOptSolver() {}

  virtual void minimize();

  void set_initial_point(std::vector<double>& pt)
		{curr = pt;}

protected:

  void initialize_best_point() {opt_response().point.resize(problem.num_real_params());}
  std::vector<double> curr;
};


class AnotherOptSolver : public OptSolver<utilib::BasicArray<double> >
{
public:

  AnotherOptSolver() {}
  virtual ~AnotherOptSolver() {}

  virtual void minimize();

  void set_initial_point(utilib::BasicArray<double>& pt)
		{curr = pt;}

protected:

  void initialize_best_point() {opt_response().point.resize(problem.num_real_params());}

  utilib::BasicArray<double> curr;
};
