/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

/**
 * \file DirectUserResponseApplication.h
 *
 * Defines the colin::DirectUserResponseApplication class.
 */

#ifndef colin_DirectUserResponseApplication_h
#define colin_DirectUserResponseApplication_h

#include <acro_config.h>
#include <colin/OptApplication.h>
#include <colin/UserResponse.h>

namespace colin {


/// TODO
template <class DomainT, class ResponseT, class FuncT>
class DirectUserResponseApplication : public DirectApplicationBase<DomainT,ResponseT,FuncT>
{
public:

  /// Generic constructor.
  DirectUserResponseApplication(int app_mode_, FuncT fn) 
	: DirectApplicationBase<DomainT,ResponseT,FuncT>(app_mode_,fn) {}

  ///
  void EvalFn(DomainT& point, ResponseT& response)
	{
        bool evalf_flag, evalg_flag, evalcf_flag, evalcg_flag;
	response.get_request_summary(evalf_flag,evalg_flag,
						evalcf_flag,evalcg_flag);

	if (evalf_flag) {
	   uresponse.evalf_flag = evalf_flag;
	   uresponse.evalf = &(response.function_value());
   	   response.request_vector()[0] &= mode_f;
   	   response.response_vector()[0] |= mode_f;
	   }
	if (evalg_flag) {
	   uresponse.evalg_flag = evalg_flag;
	   uresponse.evalg = &(response.function_gradient());
   	   response.request_vector()[0] &= mode_g;
   	   response.response_vector()[0] |= mode_g;
	   }
	if (evalcf_flag) {
	   uresponse.evalcf_flag = evalcf_flag;
	   uresponse.evalcf = &(response.constraint_values());
   	   for (unsigned int i=0; i<response.constraint_values().size(); i++) {
     	     response.request_vector()[1+i] &= mode_f;
     	     response.response_vector()[1+i] |= mode_f;
     	     }
	   }
	if (evalcg_flag) {
	   uresponse.evalcg_flag = evalcg_flag;
	   uresponse.evalcg = &(response.constraint_gradients());
   	   for (unsigned int i=0; i<response.constraint_values().size(); i++) {
     	     response.request_vector()[1+i] &= mode_g;
     	     response.response_vector()[1+i] |= mode_g;
     	     }
	   }
	   
	(*(this->eval_fn))(point, uresponse);
	}
		
protected:

  /// TODO
  UserResponse<typename ResponseT::vector_t> uresponse;

};

}

#endif
