/*
================================================================================
    PROJECT:

        John Eddy's Genetic Algorithms (JEGA) Managed Front End

    CONTENTS:

        Implementation of class MDesign.

    NOTES:

        See notes of MDesign.hpp.

    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        This library is free software; you can redistribute it and/or
        modify it under the terms of the GNU Lesser General Public
        License as published by the Free Software Foundation; either
        version 2.1 of the License, or (at your option) any later version.
        
        This library is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
        Lesser General Public License for more details.
        
        You should have received a copy of the GNU Lesser General Public
        License along with this library; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
        USA

    VERSION:

        1.0.0

    CHANGES:

        Thu Feb 15 08:41:41 2007 - Original Version (JE)

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the implementation of the MDesign class.
 */




/*
================================================================================
Includes
================================================================================
*/
#include <stdafx.h>
#include <MDesign.hpp>

#pragma unmanaged
#include <../Utilities/include/Design.hpp>
#include <utilities/include/EDDY_DebugScope.hpp>
#pragma managed






/*
================================================================================
Namespace Using Directives
================================================================================
*/
using namespace std;
using namespace JEGA::Utilities;








/*
================================================================================
Begin Namespace
================================================================================
*/
namespace JEGA {
    namespace FrontEnd {
        namespace Managed {





/*
================================================================================
Static Member Data Definitions
================================================================================
*/








/*
================================================================================
Mutators
================================================================================
*/

void
MDesign::SetVariable(
    std::size_t num,
    double val
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    this->_design->SetVariableValue(num, val);
}

void
MDesign::SetObjective(
    std::size_t num,
    double val
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    this->_design->SetObjective(num, val);
}

void
MDesign::SetConstraint(
    std::size_t num,
    double val
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    this->_design->SetConstraint(num, val);
}



/*
================================================================================
Accessors
================================================================================
*/

double
MDesign::GetVariable(
    size_t num
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    return this->_design->GetVariableValue(num);
}

double
MDesign::GetObjective(
    size_t num
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    return this->_design->GetObjective(num);
}

double
MDesign::GetConstraint(
    size_t num
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    return this->_design->GetConstraint(num);
}

/*
================================================================================
Public Methods
================================================================================
*/
std::size_t
MDesign::GetNDV(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    return this->_design->GetNDV();

} // MDesign::GetNDV

std::size_t
MDesign::GetNOF(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    return this->_design->GetNOF();

} // MDesign::GetNOF

std::size_t
MDesign::GetNCN(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    return this->_design->GetNCN();

} // MDesign::GetNCN

bool
MDesign::IsEvaluated(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    return this->_design->IsEvaluated();
}

bool
MDesign::IsFeasible(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    return this->_design->IsFeasible();
}

bool
MDesign::SatisfiesBounds(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    return this->_design->SatisfiesBounds();
}

bool
MDesign::SatisfiesConstraints(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    return this->_design->SatisfiesConstraints();
}

void
MDesign::SetIllconditioned(
    bool lval
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    return this->_design->SetIllconditioned(lval);
}

bool
MDesign::IsIllconditioned(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    return this->_design->IsIllconditioned();
}


/*
================================================================================
Subclass Visible Methods
================================================================================
*/








/*
================================================================================
Subclass Overridable Methods
================================================================================
*/

JEGA::Utilities::Design&
MDesign::Manifest(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
    return *this->_design;
}








/*
================================================================================
Private Methods
================================================================================
*/








/*
================================================================================
Structors
================================================================================
*/

MDesign::MDesign(
    JEGA::Utilities::Design* toWrap
    ) :
        _design(toWrap)
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_design != 0x0)
}

MDesign::~MDesign(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    this->_design = 0x0;
}






/*
================================================================================
End Namespace
================================================================================
*/
        } // namespace Managed
    } // namespace FrontEnd
} // namespace JEGA

