/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:       DistinctConstraints
//- Description: Container class of linear constraints and bounds employing 
//-              the "distinct" approach to variables usage.
//- Owner:       Mike Eldred
//- Version: $Id: DistinctConstraints.H 5793 2009-03-31 03:15:00Z mseldre $

#ifndef DISTINCT_CONSTRAINTS_H
#define DISTINCT_CONSTRAINTS_H

#include "DakotaConstraints.H"
#include "DataVariables.H"


namespace Dakota {

/// Derived class within the Constraints hierarchy which employs
/// the default data view (no variable or domain type array merging).

/** Derived variable constraints classes take different views of the
    design, uncertain, and state variable types and the continuous and
    discrete domain types.  The DistinctConstraints derived
    class separates the design, uncertain, and state variable types as
    well as the continuous and discrete domain types.  The result is
    separate lower and upper bounds arrays for continuous design,
    discrete design, uncertain, continuous state, and discrete state
    variables.  This is the default approach, so all iterators and
    strategies not specifically utilizing the All or Merged views use
    this approach (see Variables::get_variables(problem_db) for
    variables type selection; variables type is passed to the
    Constraints constructor in Model). */

class DistinctConstraints: public Constraints
{
public:

  //
  //- Heading: Constructor and destructor
  //

  /// default constructor
  DistinctConstraints();
  /// standard constructor
  DistinctConstraints(const ProblemDescDB& problem_db,
		      const pair<short,short>& view,
		      const Sizet2DArray& vars_comps);
  /// destructor
  ~DistinctConstraints();

  //
  //- Heading: Virtual function redefinitions
  //

  void write(ostream& s) const;
  void read(istream& s);

protected:

  //
  //- Heading: Virtual function redefinitions
  //

  void copy_rep(const Constraints* con_rep);
  void reshape_rep();

  void build_active_views();
  void build_inactive_views();

private:

  //
  //- Heading: Convenience functions
  //
};


inline DistinctConstraints::DistinctConstraints()
{ }


inline DistinctConstraints::~DistinctConstraints()
{ }

} // namespace Dakota

#endif
