#!/bin/csh -f

# Build on the goodyear-sierra compile node.
# Note that to build an Intel binary we must change from the default pathscale
# modules.

module switch compilers/pathscale-3.2 compilers/intel-10.1.015
module switch mpi/openmpi-1.2.5-pathscale-3.2 mpi/openmpi-1.2.7-intel-10.0
module load libraries/intel-mkl-10.0.3.020
 
echo "Assumes that environment variable prefix is set to desired install directory;."
echo "Currently prefix=$prefix"
 
echo "This script should run in the Dakota directory; pwd = `pwd`"
                 
setenv CC icc
setenv CXX icpc 
setenv F77 ifort 
setenv FC ifort 
 
setenv CFLAGS -O2
setenv CXXFLAGS -O2
setenv FFLAGS -O2
setenv FCFLAGS -O2
 
setenv BLAS_LIBS "-L$MKL_LIB -lmkl_em64t"
setenv LAPACK_LIBS "-L$MKL_LIB -lmkl_lapack"
setenv LDFLAGS "-pthread -L$MKL_LIB -lguide" 
 
./configure --prefix=$prefix --without-graphics 

# If configure successful, then must execute the following to make and install dakota
  
# make >&! dakota_make.log
# make install

# To finish copying files, setting permissions, and creating links, change to the
# Dakota directory and run the following script:

#   test/sqa/finish_install.csh
     
echo "Configure complete.  If success, now make and install."
echo "     make >&! dakota_make.log"
echo "     make install"
echo "     test/sqa/finish_install.csh

