//*************************************************************************
// * Copyright (c) 2004   The Regents of the University of California.
// * Produced at the Lawrence Livermore National Laboratory.
// * Written by Charles Tong.
// * All rights reserved.
// *
// *  This program is free software: you can redistribute it and/or modify
// *  it under the terms of the GNU General Public License as published by
// *  the Free Software Foundation, either version 2 of the License, or
// *  (at your option) any later version.
// *
// *  This program is distributed in the hope that it will be useful,
// *  but WITHOUT ANY WARRANTY; without even the implied warranty of
// *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// *  GNU General Public License for more details.
// *  You should have received a copy of the GNU General Public License
// *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
// *
//*************************************************************************
// * Definition for the Morris one-at-a-time sampling class
// ************************************************************************

#ifndef __MOATSAMPLINGH_
#define __MOATSAMPLINGH_

#include "sData.h"
#include "DakotaPsuade.H"

class MOATSampling: public DakotaPsuade
{
   int    P_;
   int    nSamples_;
   int    nInputs_;

public:

   MOATSampling();
   MOATSampling(int seed, int partitions);
   ~MOATSampling();

   int initialize(sData &);

private:

   int generate(double **);
};

#endif // __MOATSAMPLINGH_

