/*  _________________________________________________________________________
 *
 *  Coliny: A Library of COLIN optimizers
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top Coliny directory.
 *  _________________________________________________________________________
 */

/**
 * \file DomainOpsBase.h
 *
 * Defines the coliny::DomainOpsBase class.
 */

#ifndef coliny_EAgenericDomainOpsBase_h
#define coliny_EAgenericDomainOpsBase_h

#include <acro_config.h>
#include <utilib/AnyRNG.h>
#include <utilib/ParameterSet.h>

namespace coliny {


///
/// A base class that can be used to define the OpsClass needed for a 
/// EAgeneric object.
///
template <class DomainT, class InfoT>
class DomainOpsBase : public utilib::ParameterSet
{
public:

  ///
  DomainOpsBase() {}

  ///
  virtual void reset() {}

  ///
  virtual void write(std::ostream& os) const {}

  ///
  virtual void randomize(DomainT& point, InfoT& info) {}

  ///
  virtual void initialize_point(DomainT& point, InfoT& info) {}

  ///
  virtual void read_point(std::istream& istr, DomainT& point, unsigned int& moved) {}

  ///
  virtual int apply_xover(DomainT& parent1, InfoT& info1, 
			  DomainT& parent2, InfoT& info2,
			  DomainT& child,   InfoT& info_c)
                        {return 3;}

  ///
  virtual bool apply_mutation(DomainT& point, InfoT& info,
					int parent_ndx)
                        {return false;}

  ///
  virtual void set_rng(utilib::AnyRNG& rng_) {}

};

}

#endif
