#!/bin/csh 
source /etc/profile.d/00-modules.csh
source /etc/profile.d/01-module-loader.csh

# NOTES
#   on thunderbird, DAKOTA 4.2 is built with the following modules:
#     compilers/intel-10.1-f015-c015
#     mpi/mvapich-0.9.8_ofed_intel-10.1-f015-c015
#     libraries/intel-mkl-10.0.4.023
#
#   At the current time, these are the same modules loaded for nightly testing.
#   If production DAKOTA and nightly testing diverge to different compilers, libraries,
#   or MPI versions, it should be documented here for correct nightly build/test.   

setenv PATH "${PATH}:/usr/bin"

# Run nightly test on thunderbird from a script so we can change modules
# to get mvapich
/usr/kerberos/bin/kinit -k -t ${HOME}/dakota.keytab dakota 

echo "My environment on thunderbird "
env
echo " "

module list
echo "...add module snl"
module load snl
echo "switch to mvapich modules..."
module switch mpi/openmpi-1.2.7_ofed_intel-10.1-f015-c015 mpi/mvapich-0.9.8_ofed_intel-10.1-f015-c015
echo "...add module for MKL BLAS and LAPACK"
module load libraries/intel-mkl-10.0.4.023
echo "...add module for torque"
module load system/torque-2.1.8
module list
echo " "
echo "PATH=$PATH"
echo " "

cd /projects/dakota
 
/projects/dakota/Dakota/test/sqa/run_base_test.csh /projects/dakota/nightly/builds votd >>& ${HOME}/cronlogs/${SNLCLUSTER}/run_base_test
