# include <fstream>
# include <string>

namespace webbur
{
  void chebyshev1_compute ( int order, double alpha, double beta, double x[], 
    double w[] );
  void chebyshev1_compute_points ( int order, double alpha, double beta, 
    double x[] );
  void chebyshev1_compute_weights ( int order, double alpha, double beta, 
    double w[] );
  double chebyshev1_integral ( int expon );

  void chebyshev2_compute ( int order, double alpha, double beta, double x[], 
    double w[] );
  void chebyshev2_compute_points ( int order, double alpha, double beta, 
    double x[] );
  void chebyshev2_compute_weights ( int order, double alpha, double beta, 
    double w[] );
  double chebyshev2_integral ( int expon );

  void clenshaw_curtis_compute ( int order, double alpha, double beta, 
    double x[], double w[] );
  void clenshaw_curtis_compute_points ( int order, double alpha, double beta, 
    double points[] );
  void clenshaw_curtis_compute_weights ( int order, double alpha, double beta,
    double w[] );

  void comp_next ( int n, int k, int a[], bool *more, int *h, int *t );

  void dtable_close_write ( std::ofstream &output );
  void dtable_data_write ( std::ofstream &output, int m, int n, double table[] );
  void dtable_header_write ( std::string output_filename, std::ofstream &output, int m, 
    int n );
  void dtable_write ( std::string output_filename, int m, int n, double table[], 
    bool header );

  void fejer2_compute ( int order, double alpha, double beta, double x[], 
    double w[] );
  void fejer2_compute_points ( int order, double alpha, double beta,
    double points[] );
  void fejer2_compute_weights ( int order, double alpha, double beta, 
    double w[] );

  void gegenbauer_compute ( int order, double alpha, double beta, double x[], 
    double w[] );
  void gegenbauer_compute_points ( int order, double alpha, double beta, 
    double x[] );
  void gegenbauer_compute_weights ( int order, double alpha, double beta, 
    double w[] );
  double gegenbauer_integral ( int expon, double alpha );
  void gegenbauer_recur ( double *p2, double *dp2, double *p1, double x, 
    int order, double alpha, double c[] );
  void gegenbauer_root ( double *x, int order, double alpha,  double *dp2, 
    double *p1, double c[] );

  void gen_hermite_compute ( int order, double alpha, double beta, double x[], 
    double w[] );
  void gen_hermite_compute_points ( int order, double alpha, double beta, 
    double points[] );
  void gen_hermite_compute_weights ( int order, double alpha, double beta, 
    double weight[] );
  double gen_hermite_integral ( int expon, double alpha );

  void gen_laguerre_compute ( int order, double alpha, double beta, double x[], 
    double w[] );
  void gen_laguerre_compute_points ( int order, double alpha, double beta, 
    double points[] );
  void gen_laguerre_compute_weights ( int order, double alpha, double beta, 
    double weight[] );
  double gen_laguerre_integral ( int expon, double alpha );
  void gen_laguerre_recur ( double *p2, double *dp2, double *p1, double x, 
    int order, double alpha, double b[], double c[] );
  void gen_laguerre_root ( double *x, int order, double alpha, double *dp2, 
    double *p1, double b[], double c[] );

  void hermite_compute ( int order, double alpha, double beta, double x[], 
    double w[] );
  void hermite_compute_points ( int order, double alpha, double beta, 
    double points[] );
  void hermite_compute_weights ( int order, double alpha, double beta, 
    double weight[] );
  double hermite_integral ( int n );
  void hermite_lookup_points ( int order, double alpha, double beta, 
    double points[] );
  void hermite_lookup_weights ( int order, double alpha, double beta, 
    double w[] );
  void hermite_recur ( double *p2, double *dp2, double *p1, double x, 
    int order );
  void hermite_root ( double *x, int order, double *dp2, double *p1 );

  int i4_max ( int i1, int i2 );
  int i4_min ( int i1, int i2 );
  int i4_power ( int i, int j );
  int i4vec_product ( int n, int a[] );

  void jacobi_compute ( int order, double alpha, double beta, double x[], 
    double w[] );
  void jacobi_compute_points ( int order, double alpha, double beta, 
    double points[] );
  void jacobi_compute_weights ( int order, double alpha, double beta, 
    double weight[] );
  double jacobi_integral ( int expon, double alpha, double beta );
  void jacobi_recur ( double *p2, double *dp2, double *p1, double x, int order, 
    double alpha, double beta, double b[], double c[] );
  void jacobi_root ( double *x, int order, double alpha, double beta, 
    double *dp2, double *p1, double b[], double c[] );

  void laguerre_compute ( int order, double alpha, double beta, double x[], 
    double w[] );
  void laguerre_compute_points ( int order, double alpha, double beta, 
    double points[] );
  void laguerre_compute_weights ( int order, double alpha, double beta,
    double weight[] );
  double laguerre_integral ( int expon );
  void laguerre_lookup_points ( int order, double alpha, double beta, 
    double points[] );
  void laguerre_lookup_weights ( int order, double alpha, double beta, 
    double w[] );
  void laguerre_recur ( double *p2, double *dp2, double *p1, double x, 
    int order, double b[], double c[] );
  void laguerre_root ( double *x, int order, double *dp2, double *p1, 
    double b[], double c[] );

  void legendre_compute ( int order, double alpha, double beta, double x[], 
    double w[] );
  void legendre_compute_points ( int order, double alpha, double beta, 
    double points[] );
  void legendre_compute_weights ( int order, double alpha, double beta, 
    double weight[] );
  double legendre_integral ( int expon );
  void legendre_lookup_points ( int order, double alpha, double beta, 
    double points[] );
  void legendre_lookup_weights ( int order, double alpha, double beta, 
    double w[] );

  void patterson_lookup_points ( int order, double alpha, double beta, 
    double points[] );
  void patterson_lookup_weights ( int order, double alpha, double beta, 
    double w[] );

  double r8_abs ( double x );
  double r8_choose ( int n, int k );
  double r8_epsilon ( );
  double r8_factorial ( int n );
  double r8_factorial2 ( int n );
  double r8_gamma ( double x );
  double r8_huge ( );
  double r8_hyper_2f1 ( double a, double b, double c, double x );
  double r8_max ( double x, double y );
  double r8_mop ( int i );
  double r8_psi ( double xx );

  int r8col_compare ( int m, int n, double a[], int i, int j );
  void r8col_sort_heap_a ( int m, int n, double a[] );
  int *r8col_sort_heap_index_a ( int m, int n, double a[] );
  int r8col_sorted_unique_count ( int m, int n, double a[], double tol );
  void r8col_swap ( int m, int n, double a[], int j1, int j2 );
  void r8col_undex ( int x_dim, int x_num, double x_val[], int x_unique_num, 
    double tol, int undx[], int xdnu[] );
  void r8col_unique_index ( int m, int n, double a[], double tol, 
    int unique_index[] );

  int r8vec_compare ( int n, double a[], double b[] );
  void r8vec_copy ( int n, double a1[], double a2[] );
  void r8vec_direct_product2 ( int factor_index, int factor_order, 
    double factor_value[], int factor_num, int point_num, double w[] );
  double r8vec_sum ( int n, double a[] );

  void sort_heap_external ( int n, int *indx, int *i, int *j, int isgn );

  void timestamp ( );
  char *timestring ( );

  void vec_colex_next3 ( int dim_num, int base[], int a[], bool *more );
}

