/*!\file:  DistributeNumDofs.cpp
 * \brief: figure out the maximum number of dofs per grid.
 */ 

#include "../../include/macros.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../shared.h"

int DistributeNumDofs(int *pnumdofs,int analysis_type,int sub_analysis_type){

	int numdofs=2; //default numdofs
	int i;

	/*ok, according to analysis type: */
	if (analysis_type==ControlAnalysisEnum){
		if (sub_analysis_type==HorizAnalysisEnum){
			numdofs=2;
		}
		else if (sub_analysis_type==VertAnalysisEnum){
			numdofs=1;
		}
		else if (sub_analysis_type==StokesAnalysisEnum){
			numdofs=4;
		}
		else if (sub_analysis_type==HutterAnalysisEnum){
			numdofs=2;
		}
	}
	else if (analysis_type==DiagnosticAnalysisEnum){
		if (sub_analysis_type==HorizAnalysisEnum){
			numdofs=2;
		}
		else if (sub_analysis_type==VertAnalysisEnum){
			numdofs=1;
		}
		else if (sub_analysis_type==StokesAnalysisEnum){
			numdofs=4;
		}
		else if (sub_analysis_type==HutterAnalysisEnum){
			numdofs=2;
		}
	}
	else if (analysis_type==SlopecomputeAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==ThermalAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==MeltingAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==PrognosticAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==Prognostic2AnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==BalancedthicknessAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==BalancedvelocitiesAnalysisEnum){
		numdofs=1;
	}
	else ISSMERROR("%s%i%s"," analysis type: ",analysis_type,"  not implemented yet!");

	/*Assign output pointers:*/
	*pnumdofs=numdofs;;

	return 1;
}
